(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     63407,       1274]
NotebookOptionsPosition[     61446,       1232]
NotebookOutlinePosition[     61785,       1247]
CellTagsIndexPosition[     61742,       1244]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["\<\
This Notebook contains supplementary material related to the paper
Stanley Rabinowitz, \[OpenCurlyDoubleQuote]Relationships Between Six Circles \
Associated with a Triangle\[CloseCurlyDoubleQuote], 
submitted to the International Journal of Computer Discovered Mathematics, \
October 2019.
http://www.journal-1.eu/

This Notebook is Copyright \[Copyright] October 2019 by Stanley Rabinowitz \
(stan.rabinowitz@comcast.net) and is published with open access. This \
Notebook is distributed under the terms of the Creative Commons Attribution \
License which permits any use, distribution, and reproduction in any medium, \
provided the original author and the source are credited.
------------------------------------------------------------------------------\
\>", "Text",
 CellChangeTimes->{{3.77602941072921*^9, 3.776029415463889*^9}, {
  3.776029483519946*^9, 3.7760295042638693`*^9}, {3.776261082594401*^9, 
  3.776261180210319*^9}, {3.776261262802527*^9, 3.7762614216668177`*^9}, {
  3.7762614917472763`*^9, 3.776261550442977*^9}, {3.776261588698138*^9, 
  3.7762616175952168`*^9}, {3.7762617208677483`*^9, 3.776261729802679*^9}, {
  3.780343841826885*^9, 3.780343934037478*^9}, {3.780343965525668*^9, 
  3.780343972580963*^9}},ExpressionUUID->"3b253b36-7527-4638-b54d-\
48bdbb2a433f"],

Cell["Proof of Theorem 4", "Text",
 CellChangeTimes->{{3.7758429804664707`*^9, 3.77584299516156*^9}, 
   3.775843742043623*^9, 3.775853128120242*^9, {3.7759011273964653`*^9, 
   3.775901139220099*^9}},ExpressionUUID->"bb4009fc-896b-4c81-974d-\
da28017f000b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{"===", "===", "===", "===", "===", "===", " ", 
   RowBox[{
   "I", " ", "N", " ", "C", " ", "E", " ", "N", " ", "T", " ", "E", " ", 
    "R"}], " ", "===", "===", "===", "===", "==="}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.775676714648102*^9, 
  3.7756767274077873`*^9}},ExpressionUUID->"0c1d6593-ff81-4368-bb5d-\
ae93290bc519"],

Cell[TextData[{
 "        ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06UVD^?93TAanoi:@aLVP>i
OVGJNFB6AH8;6Teo0BP9XAEm6>H`GimO>1gQ[:Z/j]J^A][]nYOShGPi8^ZKnn:n
^N3nkZ;kaOgdnG]`Wklj?g__Pem[B;5m26G9YEKng[HJ@bk^jnM6iiegO`[l9mH`
GMkL]/enRCVjD>ZliI3M4M_BG6]IG5gW;JeaMM6_R4Z[:`7>?TI3YX]Kb^ac3/D`
Uo>laN[Q[Y`6X_8^Qe=[P^^B9n<DUS3G//DQci3;d<Z`LA_U=90Qkco^JkORdAX>
JhB0`II]LB6^LePah<2VT?Tbi:gIc2nIDd^LjkZiV^NhK6T05kM^lh8cES_3UIJ5
RbPG^N<>Z:QV`1d:HLhaU/65JnBe[VV8<^@bbAfK?XJ=NbRWP@aaigJ@Z0PUcSk8
3L>6if>cPf5YWILL=ZiF^H8?o241R7HQ4aIi00A5R<^LDZR7@nQDei9M<4J6Z3SX
3?=YCS6]Tg6Zfe`aYMQb5fL0I:ZCHN<^WI7MK[;KGMbi;B@V8S[5aF>;eLoIedA<
3:bD>HE]VJ9Oa2PBjF7f/AHGJYgG9=IA1>e8Va8ZYU=<m?En8djDdd1DgWj[oEA>
Lmh:C8eCg>I2RQcTM@CS3jgde=1L>@eTb3^gQTA6a8RQL:/HZ1MU:f8=`m8baiZ8
0jbo;BVkV0TAU4gcV[OJ?lYm<5]NhmBoYbZ4B=Y5Hf28RX78<1oW]J`BIS^K9RnC
]i=94Pd4LM2Y<XH=QIGC@;XlS7M^Q5HVR;^`9PZMa4JT^Y8bQW67]663R6NG]NPM
9Ii[EI=Lg;K<9O[0YI^=:WL:BCifnP6XT</d<4`>lcbh]5_VSJaB@HIPPZk;KP]>
DLcd2/YY82J_Vh2bEb]ZYOJdU9YCB>CcXbNUN_:eI;aMiVd]7<DjE4X<YKOokl<:
34fgb0@EWT^59be4?j=1M8l9Dn9/82jK=MlL0/^j22f1kV?IYYdf^AnlO_;_i4E/
nFhJ?=9KG]gYl[fcnGjaQcFhjPUfhO;Y5L6LB1;nlXMg[fo^YmMGX]Jmo]^mo?>?
k_DGmo>[nc9m0i83T6?FY>Bli4k2Z7egCAb<f6@O7oDKJkniJn=L6a6CRIDNJ3eM
2aiJVf0a>KZo[oKd4Qn[;INne_:9nbNeEe`XW4?dDh?ojehhZY=2`FmBfLAS_lkT
X[^6:ZmD3mDgP^4f4Fh]7jA4lY:N1/b=jDoe3gA^TJ;aW_k_f_iNei<DT_BKm_ic
SeM9J>mEnU?cGlk<_i0=fo[K[Jo9CUWKTeeNYI77MfIOG:W?]BK494]?]JKcX7]i
cnC>`QfCdCV@I3mXfUooMlbL9K]RVDNk;UEPomnNMnAodn=ggGYGeXnH3`mdACi0
ONQj0mfjbfd4T<1o@_ck<lOUi<RL4lTmJ5G_Dn;2746U?Z7^=G:WWUknL2Hj]>KS
OG9g8<NK?k2To3^DJbfIXPTMbSk?7>JPPI4M?S?d45aKiRT906eH/S78T8/[582j
[=Am?LD`d9UgAP?XD`W]aP4[Ldf<5H=AHOjBfFb8D`AaGBU:n7iZ6W[CDnjLkVhW
kLdWhT4RcX]AN9n>TKU4Eh/Vi]?4o/NITfAB>GdAKX[J>XRO^XL1]4mH>[jlC@N/
c;5@BR^MeiYTb:;OJN?KV<`DHFbTPfDjYV?^V;AEbUdi3J@?P]0=K9WmB^DmL::1
IEbL3_9fQ?kcX5G73YX[Ym_k]OkcbT7O2=jmjZid2B?kgWO>95g6XN[8eEN[fToN
_>GN>mJ/79=7ZVhKnnPLMEYD:38>dL?]KEQNb0X@>MAJd4KE0FWE6K49F=iTa@9]
WAkJnBRP/Z3J8LJiBYMHYNEC=X4FE<IGWAB30R:;a6T::CJ^/O=Y[lWE_NjbISP5
VFAPe:YfkIFKZ3m=6IHH^<FNYHM^VEkb_E_<^eM^fGbO@7FbXdlIF6134JFF<D0b
S24lk_?]V5`E`EZEicB:na@;A?4ngjk6bI0n:@^MHP_m>AhlL6;dKO?dT=LAPWmX
IJM<Ln=TR=k_gSoF:/9@4_kL?cNmnJUoY=49<F]=O>POmi8niQn6eJF?aC[ThQo3
j2<mXaI8W]WVdFV1]8WKQUa5a5i/IeQ9d@f>Dj5c7i`DDGU2IaQ_AETRFRVW`7/R
4oj@YhS@ZEJ:3Lg9YlkYmWkgo[6RQR:>@KXg1KlROLQk[=GY7g[WZQ5nn^@`EoB1
GNMQ_6<H=TeaBmBLb=^N<7_H=`4fOQ^2/EP[UYZf`bW?3Z]]0cXSVD8J<]U>0CXk
QL<H;=3G>67T]WTHlQ@ANDdYF=TQ^h/a<ZB_<9khQZe2]RkmfSDObIc0lXcGl/@e
=gGa<=HnMLe2k5g=m^i]>V2l/RUV]g33MI>dckbbK02>>h6>/7<UoUO?SU]?CB`c
UK]b6TPO;j0K6>mII>Ueh2@[@=Y47D_Jlm<dP6iX]Imb1lfEdngmWWD3/WIV8GnJ
>3ONnJ/DY[dKN6YOfZ?S]XJh7l0f[m8:1ni10Ta/AVG3HN^MmY48a1Q/EmT1mNnm
<SAj@fA3:1@k`;Z<YAho0QahI1K>1aW]Xe0d5EPok5nKcTJo8gd1mbBniONAA`^@
:a=>;goiF6e_2mk[eIFl_D7GFN;X@P_42iH;/fR8o9;@mS1SiMDA;/XV>K;m?ikR
S_]RC3Wa?Uo;4c[5Z62/WF5PW5Z[97/OTmLAND]<:c]UVQ/W@bQPCO=knhjgEahA
AX:?a>S?I`K^W:jJ6i[g`/ld>8k0bHaK67QPF7YQaPa/0JZdIO:ZbBWf<j_BkHS4
7[mA[1h_m4<0I>3>g1PId/EMH:DH/a/MYS@HWM6:adBW8DdATJHj:JIjCf4`^[gM
_GW7diWXC1k5kdf9oM_1_0`mkhg5c3?G^ebf/XHUcdl1:fd[Tm6BeSFjA3BfSBmc
kTiW28<ZCdnXU2_59PKFOTXi6H:=MTk@jBV<FiI:ICM>TKU3i4dVCa6I^e@[`dac
hcB@;^mIYBF<hYRKW[j3OoiPYDd<8LN]]GfV6QJo1IOHdboAld/99AKCjIJkOK[`
^L`/A>P/n]M<`;84=g;i<L6fhW:nOJHT<W1^OS/`h=NE0oofRO=M?4FfOFgZ:_T>
_5mRIL0Pg=j_0=?;id>84^<?EcJ4TOih`^jhOM1[bjmMF2mgZnf[`6hbO<o=:HJk
b@P>^1QQnmAn@^3G/og3OUEH:EdcaLjcVdWUZIUfcMA6@lnFa;8>K?l>ZbR^:N?S
1ncSGSjIOJH_o`N0_6HO2VE^I7=dLVEQK@YUKVA_HVX:=B0`86mRJPXb=3<c2VE^
I6mRJPXb830PKf9Z2S`l82mDNG1U82m@HFMU82m@HG9UKW@P<b0`858P;e9ULfme
LV=ULb0f830PDR0_@fm^M6E^M7<P=20`858P;deUI6UQ@Vmh85/`830P<cHh838h
<Ed:?Sh:IFiTKf9Z2SHP<21_HVX:?3`P;e1bKf=CIG@PFb0_D4A682mDIGQd85dP
;d=_K6mbDg1QHfDP?3`P;d=c<B0g830PDR0n?R0_AVm^M20l?20_E5@a83PP<21B
2RmDE3<P<C0P<21B83hn83hn2VE^I6mRJPXa<B0`86mRJPXl?20_C6E^IgAX834b
830PDR0_CR0c82m1K7AULViQM6DP;dAUMVUSIE97@R0_AVU/M6Eb82m6K65dIDAU
HfmTIB0n?PYcM79UHFd:N06MUWMDDmTFQlnm=kg@4R8P9O@JNPTPdS]85@AARDV0
D0:6Q2IfA0E6514YEVAD`057Qb9SAA@;Ph9Re`Wb4536`E54ANGMS6/9kjdelmjJ
oLMIgmWW]mOIInmmekX0D?b21<9dF060=:5H5>k[`E`B4l_4m`8H404>F070hFIV
14OhA0;Do;dmVIVXB<Jcm^h^P6BkfbboD2Ice_moTB8g@b@600Y5eCHlORHGi@:D
Dk?56C;o1<[dUBTbQS4b5Z49XZ`RhlB_K?JWiR^kbIRG9^BQ6UW>6K`dWXbkD=jJ
9N6SS0BQG9PUh6NSO0MU_EA9VP3UmbSCdoRLC00`59UOc>LVXFb9<TDD6Nj9lP80
29C4>Kab3X_i>FRN07RVInB:18U9HZHAeiQYiNS8I_[a/e?iHS4[U<==hHQhC<od
]0b><1N0[fnFA@4UFFfIJ97][Ac]kEWFiVSi_mWO7WiCoCg8N_]ElBK/cii1S9iI
gfc/[2nm5P3f95ZK7K>nUED0]6d6@>GQ[4o_803b1@2dgYcc7XI/GY;4hP`W2h_/
k6ac0Im[;R_X=o^OPVo:_hHimiW;k_]F>jHG?h4SBADcIDGUYZNVBdC<c0`>UlmT
oOL@on?0>FW=bL</W9o05o65j5EAj9@9Q8UX^hDlPER@;V@:Q7oEhGlH=RL76GjM
JaAXMEl0OHDiD;Q91lQ_?@138`<TKSmj0Wg[Fa0a2/Rn_6R]TJmcSc9jo^Oj7`]L
RVkQC44RDnKf38mTLRFR;1VSghA/`@8BT0MdX0XdPBh`0RaP3Ab0<g03gR00Q818
40>F0bi80VU01;91?]P02T4af05fPfY`0=B1N]04CX8fL0IL15O03G0;3817@0Z6
`D/`0Mj1J@R2l10EXT6ZT1JT3iU2eQ0KFPQi@d5@>1@3aD>9T12B@?W@9ZPH:X>Z
XD=@?O@SM1Zj25f3nZ07d20d1_d1OH@AV0;CH@gH0;J0fK0k70Q7`/_PA7PEW0LG
`=_QB[PF?Pjg`QOQ6o00;8EO`Y<8@<P80m56F0PKlDA2T5PT0A4QJi4RY0:YAIZ@
3Z@K^He8TG7T0`J7XF6H61K66N>7FHcQHUIQeV9:<=FHHiQFC1OV=VH@<h7iPZER
eK6VF2N/?gH9=Q6KSBg4EV2?H5^`Uk43f67/>a`>al0IhQa`O[PHG39^=Jh4]`oG
S;^0jl<=hBKaN;`ZgQC_PPo1Lo1RO26n2WlLOakOSao6_bN@2EX4Jh8?8IHP96`T
E10J2>L8oH@A`SAAPJQ?M2:647W4G68Y/HkH@Ka972I>TaA9QR@GDR@YVKB1E4UZ
8UdV?BJm8I?9>VA7LQQI@5i?[RBO85lU3i8oD9@X9QA?BQa5@]U>>DZi@7U0ND>U
DPfXK]AHZYRjWEY?_DAmBWd_Ai<cUo>GhlV]Tj^AJiG[Ug/UCiCGUgNGGbjO9elQ
Od[nY_bh0U71@<5CPJ>`EZ56hKC2?HE9AIZRUF:8HYYRRF:3hSG5DBFlTX6B]a9?
ZD3Y/=8UYB4J@]>UNM:h]4fd>]YUfS0MAcNTnm>CjLGd7nRmm0UU9FEKiBSU7>DJ
iK?:DPK2<63h<e8IYHbCS;^<So<di[W?hloK=ZmYG_nl:IGi:VhZO9DRUFJE0IF?
ZTaEKmDDeIfZKJY?e31Z9VYQJ]UZnmD^Zhg?YlmgW/nMGcCoi?b7j[2jRGZhnV[e
`nXmjY<JVQZn6QTJEAZG=<He6IY^V/VJiI[W=<NdJ5X;]@AJiE[W]Eh`UIW^c5AV
9K>;>J6][^fW;M4nY=f[?JeSZ;=HIj=>/lhCGI8^FcM1]ebgDgM2Cd/_F2mO[e7_
XCiAWjfOY;m7_e]ob/3@8=YPRd6K`JRQRZ6oHIiQXn5S8jZAZm4ZXeZS>lHhHkIa
R_4nhe/V/8VMBI99SLU=DmSDgUAP^/ndc`a[iVPV=:/e^lNR/=aIFJa6eZ0i`cc8
O:=iVoT[2cf;F8^M5]dFGbc];5<]jb`OFBUI1EQ]]>Z`n/?Ja9Y[GF=mahIZhf>c
cZKMi[F]ZBgOM[o]OC^JGK3M5[]>^lof3_HRnbKk<@LmQgR7_@kgf7Af:;^4OMDA
jnSQ^<kaS><79g/W/M=9YmnMFLhYcPg>X`/<5o0Ge2dHL]5ahKPLLY4^I2j<GgQ`
XMAEfiGSF^_jc4gGSNMfa6g4gMPmfOfhnb/?B`nAAh_7U:NCia[?2ej8UjmGTEN_
]i;gH^mZkjLn>Sj9?Xdn4kif_Z]m;oQQo@;mM_[MlmO`io[Gndl4>0B/2NP:Y0A6
15H7?P/b2A85M@C3`@71^h8O;m9O95cD5P92o4=fQC`9=@aM5OYc62h/=:`Vk7Vh
EGQnN7L4;F95A4?4^dR?b=;8Ah^=5T/FMdK9AlE5eDM=AG]5UdE;UeP/FK?TAXaJ
S22V?AHO6aEk97IbZOOBgD^7hncR2^?^;S=LU[?/fW:eiJW;cjj@Gl5ILBXN6alM
ga3oRA?2ZNE<[_AO^GOU1=NC^hOkT^O6:nN=lEghIObA19N4/XCAA9O4GHUSBJi9
5DWS0Tm1]N1e/UobPNBYU92DXbTcZM6YcFV4]?Rddd8UHHZ`:edc?BNm;l<dXc13
^/YYeNiE4j90dI5<:7=II[^HS_i<mDR<99/UPeT;/fZbgVM7IIo:DL`Ai_CTV^A^
bag9llWkOSEV=GMeIkifoXKl`CG^J`j]QMJ^G=^iCWMM`K[QmKk[SfdPKDSIl<]6
bheU6mm^R]kDDJ1A/;iPJ;?_i/I2^D9AhKd]cU/>K<E/5Fc]gFJc[F[KUb9NdOER
bn::hTlUg9;[geUmEoWMc?J4kKfUmZGkMn1f27OLgNVjleRIHUUNfM2^h5f]iLcb
X_:g^eO/_UIQFg5P3fV?I8nd<ZRb_DZ_JTOEYnZTjX4JSi[V_NYk]nfMf/OKekoO
KGoC0Hd3a@Ln7Q@L_7o8me1[[D5]aF7LhJc3cn^Rj[ZoIgmOOdC]B?6AcdN5AjG7
`XmeeC_DecNX=i@f`XfBa[7SLLM_oN3e@g/CZnU@<j>in0@h8CWah/Oh7nnN33cI
NHYmZ^TWoIof]]1JRUZQe]cFRKJT=VUkC7_OjH3CWAg>7BdoVomlm8cfVIZcbVM;
ci7>5IbK>ImgO_92aXGaRhTGQcYGM3jj]>CBWJj`[]k;PIN_G_6iLZWK_O_lEIN[
IjhiGC]mWGfmkHKmSMHN^ijFGnanJNVekffmjG2coIKS[Hjn1GgWnUgk;mkf^WgU
S_nM6`>;1_[^;[ikoekL?NUmg_gA1jT?GSo<NSSmJ?eSk>>R9`Y?:YjZ?jgmeOSG
IZVmm>bPef3?/hQWShJh@booUOV_Cl<5cjW?:dJdA^Y7[DO?S?V<gGZam<G`bhbG
dn>5_bWn]_NEdJ^OOWOk_FMRbLC`Jm7[VCm:gZRn>O[FmVgWI>STdgMYkjJWR]j[
_SofPOfQnf?dai7Yk4ohCiFOSCmgO0WllWPVKFKVgoN4lo/:IFiTLgAbIF5]2VE^
I6mRJPXa<R0`86mRJPXb=S4b2VE^I6mRJPXg830PKf9Z2U/P;dU3@d9QLfET834a
830PDR1M2VE^I6mRJPXc830PKf9Z2S`l82mDNG1U82m@HFMULb0_CFETJF52KgPP
Fc0P<20c=SPP<SPaGB0_@fmeKW@P<B0_BfUTLb1K838P<21B85dP?Sh:IFiTKf9Z
2S4c830PKf9Z2S`l82mDNG1U82m3HGAQK6mW82m@HFMULb0c830PDR0n?PYUKVA_
HVX:>20`86mRJPXl?20_E7U`IB0_AVm^M20_DgERM7U`IB0_E79eIEAiL6DP;d9Q
LfE6Kfid82m7B4YCADX[B6E/MVEdJF=Q82m6KfidA6EcHg9YL7A_LPXa=20`858P
;dE^HfmTJFiW82m=HF=BKfeQKTE^HfmTJFiW82m6JG9cM4=XHG8P=3TP;daQLgA3
J65b83Ti82mGJFAdJ7<PFb0e=CH:=CDf83De=R0e=CHP=CDf83De=R0`830P<20`
830P<20`830P<20`83Hf=b0f=SLP=c8b83Lb<R0f=SLP=S4a830P<20b=cPP<0X`
830P<20`83Lg>20`830P<20`830P<20`830P<20`830P<20`830P<20`830P=CDf
83De=R0e<30PGB0n?PYUKVA_HVX:<C@P<21_HVX:?3`P;eAiL6DP;dI_KWA4IG=S
LVU`M6mb82m6KfidCV5]IB0_AdQ:DdE::dQUK7IUM6USHB0_AVaQIg<P<c8P;dI_
KWA2@Vmh85/]>CDa82dd>34P<C@d=B0a<C8bG@X_BGAQK6US@FiWK6DP<20_@G=S
IFid83Lg<20_A6EcHfE^M20]<S<`82m3HG18IFUWJ7@P=c4g82mCM6E]ER0i>20_
F4QUJFMXM0Xe<S<P;e=dIFe883Pe82m1MVMGJFAdJ20d=34P;deQN5MYI7AX834e
<30P;dI_KWA6JFaU<R0a=B0`858P?Sh:IFiTKf9Z2S4e830PKf9Z2S`l82m<IFiW
M6PP<CHP<21B82m<IFiWM6Pa83Te<30P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:
LgAbIF5]2WP1_EYiO5CEmCog;O?N;4UVcBbI=I=I/Q4b8B4QT@`Q6d]R92hI9900
`A11424:5@`80P6YRP@:R]8Z0X8I0^X0@Q7QQocZP[EZYKCE2]IOKCkF5_aE83>o
Lmn42?VY7ok`dgVOLnliMgWgg>lmifi_i/mKd089d04/e4e/WS/3Y9lk341VCI_M
?3L^JjmP_6AJngaWG>Km0>b/6G?_VQfGaBL15;JkIRg/[jmk3R3YfMJFi^WaO:3e
2eXa8BjCHARW]LjNod1Le^k7^7[FW6WmnKX7DOK>KWjP_gdhRk;cW^KI;O7bk[DH
YlfMLmolO[TLhnZile[jbi<6e>mM89RZQBM03WN300bXlFT44;i@f833G9Z?_m[>
ekI>BBZi21YATZODo5b:?cZaHmVoFjkhU8n;gf:2o6Yi6/_BXnT0:X;i_L[71g:T
NQQX8e2O6H4aB:E8nDRIVJ=<d46f`f=8cb:a<9>/PHE8Zi5nPL@=L3]A>T3Fm71R
l21I21Hb=ZST7;OZc@jC@^WhKHC8mVmeO6cjk10ahnQmB/`m2B0OYB3?TVMP>SS8
ln0QRj0Jo6Cc__AISRK<fPUcTCZ@F2TTI6N??N0h@[;0`a6/h`DkAeiao3Dgfg4n
=l:@7/LaGhC3j7DkB/4Tae7KE/N_KGLiSR2m6<oJUHhUGW7/]<eb[;M7b>HNaa>f
2<4jSlNS1CJ/nXYSMWZGHgZ^U3nn:l:lf><X`_cKPdY7@J7;TFlkilSaADB2L[I]
_2<Smfe76UK4HTilZBNXLEQ]jadS<<]^Zo2=@3Y4MY4]T46fm7S6>PhRRmgM=bJm
/2]2O[J_fYo[RI15`H9ZOeMj]LnC?]kQBJodnI2ooDeQ^G2W<4X829V2Go0:;R55
d8]JDBdVRRYA8HZR426kNdXM/T?TABQ5F5kL9lY4?T9N`TC^4=TS9NiiENA4APAA
7hUmP/I;@1lQ;niGD`jIEf@B9h^@?O_RBG^23XibW9BQIRR?0HK04961/A0VSdIT
/2:i_MADZQfY:JX/oj6PBLZi6VKnl<m4K>6^LOD=hEffD3Q0VIP]M;FhjB[cPo7l
1ISEDYJI>Fk2`Wg]Lm]VE;Bh:i[L5Be8CN4ekJfVL<MDYg=_febJh@bcgZJYdeYY
g=`BW^]^:@ng^L^MNm^UNX>bIm3/MWOiGYQALF_3gQW1U_:NmV1kQK^i?;A_J]Vl
a^_JFSg@e[bbkfV[S;i/7Ve[ZUA_D5^==7/ZKJ^A]]E8fiXJW2ZeAC]O<K>nk;ki
J9g>RYWSW65oOGS<;A<K`/kVD7V4K<O4lPG07`DeOaSlO0MH^1a`0<@nASY3hnQ]
/LoiTj2>cXimcAKSX1jPa4A;Bn0X?0YKX1]T/0=i?db6CG2:]:5_Ch;ml26a`a3X
@;n?`7QhRlARkl4<N0k;chMS/07fPP[[c0H3iZhSW]PRU8?8ChGU/Em26QC28g0H
R_2]jj0g]S>f3g<W`6f`2ek4n[lQKVH_Yh^m53/78]b2keb>>No5a/NjLEK<PS:X
`mCUL8Ahf3>aES11<F[g53`3fn1en3]IA_K7FV?]/M>aCm5DCF25NW`FTogTDkJK
NbCfE>a_/BPRhHL<K;D9e/>_l?gMn1c5ZKF2g4gVToET0a=TUS7k^AFl<MZ7>:A3
5CkE<0MF8@87h3Sl4khUGc4VE/g>Ido4lV?o0RF<`ekBW[A0>ch[lEV7OCY4I6@X
6DgZb6;b9=U0gVLbV=^H1^IniP7VLkJFWL@^I=oWk^=jn;Gl9YTbNS5f:7HbmP4H
`@Ig`SaHP[dk1ZOQ0U`R;;k;BSbTV9BAbOQdT2g<0K:=763Zb55bV]U5oT`n8enA
b`c?Z1P3TlW<ImHc;c;7V7OHVN`6mQO/WmV;g4RNhKOaifDNh@oAZM7EdGMRaK5?
Hoo6:EH45hi<6MC256S6g/j5HO0@mV8??]dhJ/OQ19bBW/n85G[QghP242faT02Y
`JNFg4aVT9UT:cV8ca59UflH70Q6cVPH8f=UjYVYc6bVPoV0jF1Cf0af;3^AkLKW
COI3mS9kVN<i7FOPZ[Pa/9JKcFg6Ic^gPn_Qg^F;n95l;Glkgl6_i]NbdoSgn0mU
BfC[I3fb[fCo`6Ua_317F8^SL`Y]mWFdiNmn74U3k@=`3d`SiF@ZM>5XK2?=d8WF
=If/@[cVPSoFb2iQZiRQJ0e7h6MX[I]Q<JaV9l6ff>oIGO0AF/X/O6D7_<2EPHgO
R:>c38JR5ODo`OB<M;o?jdUcYkZL>>EKDbaVTc7IX=MY=NX4UE8Q5`DIck4<PJ`:
MfFC<na]2W=NMgEe=YGMcIS@O4e24kZb<eaiOIV`TmI[aZc[BPJai8a19H?aT/61
TTC];86Bk2aWQM/IO[_LkHb@RKLd8?mX^C_T3?M:O8g4?bKa2LRkG5S1FF5Z;GN6
BI>c8UcIg]YIdEBNWDD>114>AGHFWCR2X:@_3/?Xi/Dh`L9XFZ8RK76GEhC=K^@a
SoED=4l?emgBD56NhW:5<0fC9SAP6mUI<l>X9jaACGM?Ga<9`]@VbSE?JPRccJ4`
ddCOYLT<6mgUHN>RljK_a:]LaMY[</><Yk:iYK<b76aJPn1B/HU:cF]A6UO_a=Lb
:d8=HK:RG`VZHa]ZB]F=[`VNYSIWF>h^LkMf]SDQ^32QXLLB]4RCKaSZ6W[<@K<T
I6LM<2dYMV7_3fB?bQi5hf:GJDTlo^_3lOCO7ZFaJLWaCc0N=f40048AL8m1?L?>
JE8SKUBfT0H]QM0i[A1a`Un8H3MWXSjS``cJ3>/9lihacN6>nZ]Z]9K7UF]Z:nnA
VbgB8U@F`_9=WNXA>59HG^efMUk4eK[9gO_gje>Jne=T7_E5X9UdX0M/9DbJ[o;]
M;7dH:mKCNiF>[k]dYRRk3IEG9>0<XF6jQcFh`9Nen0:>d>HP;_9[74AT=Lek2ET
GBQ2HR/RD6hkP7]DM/YTc<jRYSJc7=]78C/;4c9Lb0g9LUIRbiGDEYbMc/hadc^M
ULiF=2K>8lFHdM8IbT44ja/@9kPEF`b6DPKHUU1X1;hWQkh7Zf3acQ2nXJgo3AQ;
BCUmF6QX5RjV[;N^hIJ6L4MiBSQH7/9A@?<mF]L@?XZF6`YQZM`1CE7SaC==oCX7
D>OL3<c?Rkl5mbhMn8Y@IbMmIgf3faDnf]VIdTWm;Bi720a>2?HWA80FXI17B4LM
e/G8kDZAa/3UMZ5J8H[Y<3CYZaJ5NoHOAkQP@6n/>Abe;I0@;_b942jj4HA7g132
a@>JGXM`2NYLC16njCn7l<S[42kmLHB30gZSTZ=@fj24L=U?Q?3X6d6ho8H@[QS@
m3Z4:e7W2XY`eGl>hN[[41kch`R?7M0KUAb7fXjE41ko4b5LLb<8emh@`SL?J7XM
`WFXlldDhE_nL`Q?^0kQnQm7n=H1_E79fe3KFbF4Kon94;kSAQ1^^264@`>JGXO`
A=@iA16nL`3QH4XH[Yf7>`I=^o2CClbC[X4LMdZl5/Zhnn0hDQ0Y5fTH4Tf[hFl7
>m96?8m=A7XNnFk^<nQVR^2D[0SZ/<`4Y7HlS=>Cf]Dk81FNC>SMDBkTB@Mc5/mT
?:Imgdo0_KdL57Q:DDWI2MLDB[b6ob4f2FnQ=?fI1C09_/2cc5nHMUK5K^:/g6hn
TIo0;nNOTUUTihAJhCBFI?0L0MaY?7nbN8le>Wjg9>I4P4<BeA60ddQDAYhmRcc6
0/H/a_:cL11[0MbNNA3Oa6<l=3M?hm;hT<ZhMI4[On4?GaXMhFX^hed5m_hh=_P1
o`Cfd[eG916B5eAaW:3RQ2hN55EbMO]ado4?nXZP]?C2fkU3MOTSbO0lSE]co8g=
gWE7fFljMJ7]UniQ_i7N5DBmkOcCT0[KPkD5G2Eg1gngkAkk8_]b/Y8A<lB9i[_=
3iXO];i/iR6E977FA;=;/9[a?XYg92FUjQCi>]kYF>1:EKTN4PZCij@VnY:F>PYC
dj[LE8oOmEkXEEo/?@NU9GdUYKdJKE6>eUQ4<=HF5FT`P<KLXJ<G1ZfLFNGAN9GJ
A3o8mH:OV;T4]L9?A0<6N3>WEQ=j4K0D6P^dYJAPN47n<:lkEI09K^AM0Je1;lRB
R0`CG0KGf1F_7edjK4;GhP=EG^iE]V`1lGocfL;:UeM?;Ia^HA>_Y1lPf[Uca^GG
gkehoMYa:`jeWhinlj_MRjYJaQOTg]6fBl8U=oHaIn4gXkdM3c[6Z>ZcFm:WIBm8
Gi0]jo:BLF:V`YBYCf2ocMGW9n3Q`QgDJo;E3bDTi:KTYo52OVj2ZL]G[XWP[F2B
XW387<JAkUc:nYRlZ/0eZ20fD=YKfX^PG>SkG=f[Y_Q@K2A82W:6V[dPikdfCjYG
1Z`O>5HLRW1Hg@hoF3`V?n68P73UH61gYB1VGP`@[<a<2YJjQ79;Ub9VY95Sl_>B
SLUiPCQ`<R7OC_82el0hS<:89cQ4d4h<NW2Ci?>_ZObE[jkKoO8f[DMWmBJgS9Zg
ZFEoQIO_2Mi337ohAeEFiKd?AOoiKala_[VVm=i=3ccIC/Pc;></O>c^n@nD;GYf
kY]_75Pn8LoVf=_aMSB:/:9ehkdbUl<oQE`2C0ZVbQV5V40HiXQF9Q<H6N454Lom
PX9IX>BoHUD2adJ8lFGBUB3^ETA8`chnZBYA@_3RQI8n]:YBS4XdAA9Z25cAbR6I
g6;eRJCLXD@S9aYG?/WCi1WL6^KiJ3iiYfl]lmRVmmo7:h?EOOM7NC8ic:jk<^GY
j2nYKPC:HVLi:mhO>N5@<;=J^l[15:TZMGOXk]9a8dAEPP0ZAE9RhP:]CZM=C79Z
M@;XS0YS?RZF6[@T?9BHJ=>>B>:hO>M9Fh96:;C<PD9WJYD[?^8GNhoSH?NFm^5X
Wk]`MJBY6j3>Z3;4Qak7gXCnh3LiR9ca/WJl_<6[GbM_AIn@Vc0P3/h?/Q@<A7?L
=nQXZd_XL=>aK]AM=lhn7CX4RdjB5n0<N/JEV^K[dbh>g_[/iULk6UOT?3FKnJ;_
VI/2fGDcCa3]iFQ_MoAOJS9kLk7m[@NkWZ/>bUWfYNPl[lhEON<gdOlnlIHdQSFa
?g1^OR^TP0mf1X_^]a2Sj15miPKc8k2B[98;EJ;2iG?U9bKZfI=2OP[_bdMOBFNF
fP/eLh`:YTBAUV]<[o9;`?@E?CQ^`P>;LT`hCOCk0gD82Y3T1/<lGZ/c:AUT_=NI
I?LC[b7=3eHML]@W2<Lje2holBCko63CHT1m@YX[B=`1Z0L/9HghFB7Ih?KjL=IP
_X?3W@XJmG2]Bm__5PImLQiKMKQ7kAjeO6>?H^CTfm_f4eGdbe?A/j<FTo5;7efb
OGkg<hobFkmMO]_@RM7oREji<m_onKTgX^nCG;`:DQhTdbomlMO;kSViNL/ZN/O8
PQeG`i]`GF2TmNQ</:jJ=91F`ZiR=g:K53/E4GU48O<[20Pb6F54^A`31@PlFD]H
cZUG:3aJC=?c_0LmQ2RE?2]GL3:N:1W20V<Ga0P91NEheB:C:ePNYAe1KD:2dFSQ
]i:]2[<ZHI][kFBlBCKGGS3Em?FIJb]JbSn_;3M1ZK6T]:BVCg:ODS[Ya6OT7<TJ
an69T3^J4^J>QeH><J5idP@F4mSSXLcn/R_E9BD24[YJ8l9;U4BGAmb/RgDCM]fO
NeMlbQS>K>Pkm<aKc6?<A>Y`k;A;XdTTFRf]TQ/A5`hi1MjMnV5I/71R`TA=6m>F
d:IIa=c_4/HTE6/HVnQ8hQ`ja=0WfXf<d^hC^MbDVDViKT^6g>3a9i_C<b9TbSiG
n`c/H^d5fYmJmCLeTR7eBA=[ggLCZ]IThDFcAnHEC5`VhBeR9TjFe5BXOC@BJCI4
ng1Y[V5IUi?NJn6/R5i5hgC275mBNLn2/VGAYlVNEf]cOcinLGC16lcmQ9TM_3Vm
i]k2JJ4EdCoe[FO[g<=ooUS06RgZVmPfN/Zc8aamUgWMiS__Ga?:lFDF=>eLMmm^
]8Z9/C?l_Oai/:6Uk0dFYo0KBAO?>]3;Ui6Eo6XMGbnbSmPd6X=/Q8eESC38kHcM
KVIcVF9e[/KRU>NJc@kW=UMK782Jg_k^X`OQi1QOFmBmTR>=0:_AXo<VNU:lbVAi
01;djP3AJY;DPQDU7]P08@c7:TbZ02AY<A0]/P0^<AS@Q@CMRCYD?:@9Bg5I4HWA
?HA8GZBUblW`?5b2GDjO5kfZ`>GVk6BHiYS[A<o7dH]OOgGf_Y_/aba?M4LoR/5;
igLO95EnoWcdc:5efj?_ATm4Xm5Ok``mo/GCQkNlCGJCR]=oTNJJim5>YZ6M9>3m
mUe1adY=UiH9R4Yk4P=fXbSVjRbF14nRfFcid=FnFS:2VSh90bS]:nfC>^hUbAZ?
`B/CN84CF84AN9U2;F9_Tc6@JiD18^SaaUAJ=C=X_cbd9gB?XFK@6R@Cd>P51XOn
M<^XnF>;;DTOOaemiTfVW^Bl/:5QBoBA_^iM1]nLd9[j:Z8Q@bi_hWDO7H^nmkO3
dAjY3mfhi_ER7nQn]3JH9]PiC/WJlO>BG;@[U:::DJTHT<eTR^FFA5KdP3TQ<D:D
ne`K[WI8<^X;im3aj:SBWE@9WB>aNgAfeo@CjNIb[ZaW<jml`3ihnASSh0o_SiK]
RRIfHm?h8gP_3=`^5>A@53AA;NCmF/S^9QJUe;926B5gH<]Wnj6DFZK[k?m[d=g=
G[kb5_=NGli9ZJ7^_^VdSE<H?85]/62TGe@?HQ;0T4clOT:g_dc>d5`MkTE?WCY5
]kAHZRkf0Ol5fWlB[RIFj0aV[LA3`DWb1_>VN4XQ6bdJARBa:B<4^IFaFYGJG=IR
=nDZcCKkk`NIo831Bd<N04^2UgST7]jKW6P:P1jd0F8ATE?;T3>Z306RHc0`:e82
X>4`T6bL1_B7jbPHTcEZPNTgIZd;]?UZX9J^ekYHK/^Q9ehh7]d@gG=/ci=7l3=:
bYOA[kll5ogTOhTQTCmojHgXjNR[If;`bNo9F9;a>j:nm4^bl29ndRR9WXbnNb6j
Uin<OIn0n`ejnin49idBn6>`<6<XDJRE:BZ[;jmJ?E?NYQJ:A:e:cZH4Q3BiCJfb
5FLb@m:;GbeVRP<I7ZeJh4F[;mEXSI3>X=]XL`Pnfa0UHl]GUPPU9EJmT9ja8ldb
<RGM>SK9EfRnJNA[I2=nm3Q0^R0n_3Q?DUliegMl03kLXVR;=;Q7KdA[6m8kY9L^
3AYSO2gf5``gY08aNdQ1TP]<mQ@G93_e;^9:QN6<2b`fXh/HG1Q@=?_Ggoh=J1[^
?HLGg4@BRKA==ebgQan9Ne6LGSFhnPJ`RDBLDGaN7hflnL<:Q^]8h[cJ:J4^Ef]P
m]CLN[9oY47el:97Ref:7Ocoo^Y`n`:SAfGGI6Ai6c>BiL?ONG33hH<K>mnMV3EV
nn<6Zb`a`IYc5iTUIYVb9mF?cjSo[bgEeI_j=UYCFGJ5BUKV3UJg_KaZ`g<jLXk^
Cm]SOn8lo34lomUQKW38M^45jdMF=UE</S<lP=762aZ5gJIDjWfRaFTIXQi2dT63
Do1:en76Zf_@^G?m<e0_WH8eN<jAS=:TCIHYTVEj;m4Z<308ARoAbNgNn<a3mfkX
6Q@:[DK?B0PHg6T36a?L_;Mg5coGm>JggiaIM6^PJ3/cho777ogI0FoE<OiHgiLe
]dAkXaNRdG2a^fKehRn>k?cC:nm]W;aGVWo`RaMkVZ/52o[H2l6L5laTTfV7^<_4
SQDeFo@/ZiOI;4:2CJm<4E9BS6ZOU^1AAF>a:Ga6/aGo1R3/LleKg6laf;>BV]jR
8S[o35iQQX5Im:P<2RlTj]CHBkZfV572]LDU[Bg:i0@_[RdHb4db;eeKG=nc]R0@
^5m;SZl/PXc^bM0ZlZPi<>R3N@;chFO6K_Fl9K_73Ugea=b7cMgfOacjkBFRoIfE
Z`eo=>gQ7K>OgGIfmOdOW21iWn?W^Q4lSZ_dRkGPml[_nfTaDHlkTFCl4VT2<gji
mH0GMkMno1ZJQF]3>EA0YEBAh9MI>ZGQ7dc`UP2ZZ/OFEhc=[6jIeMhbOnJdITb?
im8BMDRCT>Rg=?YoVKE8Cb7]AWX=RNjVcb;m7NT:EU@QFI6bT4Z@aR==R_Go/0`<
l0C?YMO;PD5bgR0IcegGeLlO91L<TTL=T//6bJ<7bNF3i8Y1/XCN=OZ?6IAolb2I
8WU]OjL>TZMAnOl0P:_O70YUKVAcM79UHFd:IFiTKf9Z2S4f830PKf9Z2SHa<3D:
IFiTKf9Z2S4`830PKf9Z2S`l82mDNG1U82m6Kfid82mCMF9dNG1U82mDLWEUE7U`
IB0_@V5cIDI_KW@P;dA>FTiFCb]8IFafIGAYHf4P;dI_KWA4IG=SLVU`M6mb2S4g
830PDR0_E6mEKVUSKfAU834h830PDR0_AVUbLgA3J65b83<c82m<HG=d@fQQLR0c
=B0_EfUTM6Qc85/P=CDf83Ha<B0f<C4:GB0n?PYUKVA_HVX:<CPP<21_HVX:?3`P
;daUKVMdJ20a>B0`858P;dIYK7AULR0_AVaQM6E4IF=_I6DP?Sh:LgAbIF5]2WP1
GI31J/<`38K_OPXMfd=ahUb=HG@DL]PjU^d175/9Q/HfSW?8fdmf^`ifn0noY4ol
4Sog[keg6OQ72VK039?c=^4J]V@@AYbMIjd0jdan^5XcRhj<4cc/JlJUme<0:AT0
obATcFV7`h/=8ai;kIX/9^MW>7bOQeXI]QQ_^:3?d32U`>94jmidO=L;0ZoXZKOD
MgTo4ODglKE714Y4A7^?I8;5=FZ3BO/IVF`J9BlGaM3KOjg^3XcCHe:dBQHegMPY
9XDPBb8[R^g8T/RfMM/_EaJG1c`3VbdUbUZoE<lXlIc7ib=SR2E>e@o?egJi2VE^
I7=dLVEQK@YUKVA_HVX:<CTP<21_HVX:<S<i2VE^I6mRJPXa=b0`86mRJPXl?20_
E7U`IB0_AVm^M4AULf=bJG1dKg8P;dI_KWA>HFeU82m4CUY>ETl[B6E/MVEdJF=Q
82m6K65WLb0d82m6Kfid@T9_N21K;CTe<B0]=3Pa834d=3DP<C4b<Ud:;dUdHFaY
Hd5^IfaU830P;d5cHfE^M20g=c0P;dAULf=UKW@P;C8c<20_@f5`B6EYIfQd83La
=b0_DgAUKEHP>CPP;eQ8IFUWJ7@:=C8c82mCM6E]B20h=B0_@GIWEfUTM6PP=3@a
82m=HGQGJFAdJ20a=C0`82m6KfidAVU/IC8P<S0P<21B83hn2VE^I6mRJPXb<20`
86mRJPXl?20_C6E^IgAX838a830PDR0_C6E^IgAX<B0f<3Lb82m6JFadIG8P;dI/
HGAUA6ESKfAU83hn2W=dLVEQK@Yh0KeHOG@CeiFoklf<9=/hUKmU6eUB1_T3faDf
630VF1S9/OU`S4eHbL69I2?7MW5a`7QSF:Pg3MTR2=^DQ3HTBd>cb`H8HOaaZ6`J
jZA9Via^6m:N99//NeZJY=g]2BOMk=:C=TCJga_I:^Hd>Oc1bKacimigkgg_g_Nk
Cdlc<k1]AhQBJIPTJVh;mWNAO^E/1]_@fAO/SoOCG`8_j1`L/<OkBS6A]:F[omjn
N=od:56bmMh]@m?Sdom096MfQh9R7W5M1Bg^QT;_4E/4?ZnkKn3nN3mm7=blIF_W
]3gm?OBCnh;gClNWRnSK_a[/2lGmLmcPloZgKQnHk/_Pbo^gQJKmV@oi_DH<FYVn
ADWd5C8B9c=J>i7a_i:]d3?M3YNVl0n>g_>UiELXcJA?MlnjOmCiFbloll37XJ]5
:HnHoPA5dXboh8JBJ0WA70KkiIA74QIm76ibQ5Y;8m@8ZPEEPDY;EeYXV1fWKh:N
0TWD`oKC46POj76@W91>X3O1mXo:9_LT6j8l]]ZM8]/fI>KJ;<TY]Um4V67lZ>e]
bk_WF2jZMhWUSZIBd/YTmQCk;VdV6o/GL[:Me435k<QHbAIK0:HCe0lJ1TWjWK4C
X`FE]_>/S9`b`iQ2:Y3IFM__:/Y]keM4>1^e_EPDTL5N:43?oBGKU?FXkHOFNfgW
@JORYY<Ul3Q[>f7MHS]D4657AVgO/THHaS`BIc^/67[FeUMbf;Ji@[N_?AcQYdI]
eK1_M:OH5Rmef:Z/kmULAA4C@koL^]Hf_n9W]WTH23Lk9WFjdfac[HM/bf0Z/7Z;
UX7>/I?/2I[?WQQe[[I=@/AbaaY;UQj>/5eS3LDEcPSKjEkLD7bhY:78FK;FiRbY
;bZ2_?4Ehh?6^h`[SIG6DV>a/M3X<>HK<dgY9[?Y5]<LDk;9I396f;>S]CK3>GJ:
JP7;ZC6C`JA4f7=@b^OHJEein_/VfLA=I<Z<a7j=cL/X<l9>SI^51>6/@IL<4GIj
;:hjkKIQSc:BMH>I2aTgg8Tc4jOEY;678`KJVceHJjU=Gi5FGNoi[5]0]lcLBcok
/S2[MWQ=ZdlkJOE[UD:8FOdckYHIhC?i`0jH@WFUYF]JQ/H6ng^k_27E6e2m8E10
fcoHKM66>ncfTMinHK1[DV6PXk=Kl618jeM37ZeGmMQ71_EaeiVkQ7U@mHa@UgN3
KjC;7O:<3[X7_F[@hao[Z=_F?R_F_TB/KGEo9EJMV6bKR=FQSk/^E[/`MhQHkB9F
^hSEhNk@HhW5Ng]JjkH?H7OJ_Ce[k5YaZmJh_/fWfH=nCh@MQm:cPi@Y<R_?Dk4b
C7VbRfa4/KM1k`PN_C?fFnDWI8kfaOi7ZT5A9`CaJ>ebVZ:7j@Tj@`Ij1W8agDgO
XEMI;gkKVfRLgV@5m6DJa^ln@V_YgeP/mSYedCo3Oh1NY<MXQ>IPC1mU`GZ@>F<k
dGM3kZ07HmnSNKBD7Z;WZAZc7ZC;/A>a<EQKj4hjBJL`oZM<iB=bA^bif7]TX_FH
ld5HGXn]SIfQM2ZS>VZ6mT4jcicB>k5^/U0=/W^B_T_7j0GjP3g0aV?M/L7HQMPU
K5D;cJEF]=e/W5fBc/P?aIj<oChF1A;5=1mA0gB8W/KlIm2VL;AjfEOH03_47^=^
oP0OUoLZ>M5?PD<9gHkF@5_Y6d1PPUjRSnQ?k4=^TLcBP?Ab[2[f_iA2Jk1:/I8@
3J;m0mY1[>TL<k05K1E[I[_IXn`amT/nWmo9OOa_nOgl]e:C]4TJTWhYKiM7U@?:
M``YdB^aLk6Oa=jP7;;BGKB=mV1e;m85nSoj<i<`eecVI3F/S]f==/bNh1?/69_P
cFb:GN0WfJoH^na3mPUGn1bNaD_i03o4Co4GnLnU7^TajG7YEm8ENHG2UF?:n`JW
lCnR7M5mdIo7JV:GHQoSR3FA0iFYXbJjQh9HKCl]XZmQ5JOAcZ1Z;m7;m:[NgVEc
jC9m31B8YK<lE/WFXCFa>ePGjf57fBCJNCfG?g8DPROa=9k3io9Fg/7kn31oP`m;
nM9lJKGD9Ye1NdEjDoY4nTAFi0`iBkiMKZ@3LYml1>fho8`l:[nVE2/[U2IUXc:/
k5<>B9g:jlZKQSf6PhIA`hN6?n1HG6_LJSb0j[b:?O/2m_9O;YW=@oJEm5GZI1kF
@HMASF</B67/[/g/6l2[WhYSkM8NjGJn0;_Q?>g2KSe2^fVO]8V>aOiM>TU_HJM/
`IC3m:mb7EVEKj<j3m02k:;YiRjIGe9LE>RLYmkZ/>?8Wi^OUf_9bLk:c4Q?<jO>
BDU><QT=RRaaAVEN]CiPe`X3VUbX=SBDRkhJQ29hSB:0Wk9MZio]XmW5^21</ccM
l>bjc]<Mmg@W?9WI_YbFUiOI_JYMniU7]DMHfgXOi8LmZ]n^GMKUMK[lCEe>QNa`
H83MJnWff3DF/7^en/7^/3OP:BmS4fk0TEaN9Ph>=jF8RCEJ5Mb=0iIF2@n_UZMj
_5Z^2QTfbNT=K]JJeo^lWWb7``lME2dna2P_jm6@9nfO/eWM_3oRYXj0T8:KO9XD
m6/l8>I::mEbE8nF/o=mbenj<i;g`3E6SC_[Pj5`_NH>k0NhXQ/@_N01m=JdfS4]
gn_gJFc_M18RaeiT:]:=obLh0kef;DV]Dk_3_@60BbfndCagWWkhJ]C/6leeinZM
l[89bihJ1eHoDKjbO:GP=@k;WSSogMOSnUm<2FkIlm:_`MNd901P0P6e4GUZmThm
R8YTUhYKJ2V5>iL29eanQVGf89mE6/NNTIbJhV`<J/>]<fUdNn;91GXmXdViNOZO
D9dOoX6`NATZ1GncJPmO`Kme@;gl`Fa=L5YSL9Z_T32:@ROfR/J2<o:Pn;=dH]GM
5[EKe7M@[bWjZ/EkS@9m0Hg8FL_47gRccj7IoE3PJK9/CHBBVWdSS1gdAeQ/Kh@l
ePTlXd[gg0ecVMQZ?Ak4AjNl38[i3TQO;[?G8g:mf2_f/3gL^3U/[kMgHc?9CYg3
40[kGD2`e@NLJ0<R^_gi2C7Tmbo3?2ha3hK0?Nc73;gC<h3[:]NWL5Y@QSmCZK3I
]mjW3G_b=KO7SbYPndhenk@Yk5bo7ehERDbAlNhNbgC>ULRiHSk/2n>ch=UU65?h
`f4aIj]?MFQChG1nF?cNh_d8Xn/EkVU5Q8B;P3c2QY/a5Taei>/eL:P>Y>DGV2k2
UYkIDGQVogb45bOba/PUb7JaS_3BVhA`mHdP_>b64:i9I3X;hNG8^DHPO=/GQo2:
F@SGOSk2kTCNB78U/WG[2=OM98AGg@S2WQ]2f9_8M1K2mLSI:a2noH]3^64F`XfO
So3ZA=i8LPfbGJdS_?HV8Kc^AQ1^^R64kdQT>P_QI^AlQd1hoAN7L<//Q5/o7n4=
RKbAi9g8MX>>l<JKQ?3Og0S2_Q]2f9o8M1K2KLSI;a2n:h6`>enSJloQhN^>GK[Y
1o>VJb37Ti:BCWGb^m@66YNghee6_4KSAA[G7;aQh0dKcmhB6YoFh]/C_L?>lfAH
>9k9BKj0McT9ghAFaKoCV5`ATT4VLhCX0TSd8D/G8H<K`BG`Y8/dRE546d/W<I<2
_Z1RHIXS[@QD9an<G?f=l_bOEdGTMIoP_AlNKK4?i:OTfo24jj8alAeX4RmNVK@D
71n``2<d3o?:V5o`o0/Pa4h5CgE=dRg`XKCdjYGiF5LIIH<:@H]1mJ2=X2k@8>PQ
d67@LM1Id8m1ZNd[5GX3`_/PgXkL2h2>26k1Fi/8GX2P7<4hPYXQ6b4KYnFT2`/Z
W8HUUD^b34J3FUQDF:G6fJ8URiMDiRb/F/PZ8Bf^FUADF0BG[<bLK=TUgnK<b74F
iCFDU<^kgok_kC_^jooX[Egb/m7Li^XUcXJjEB?oe83[TXnW7SEaVBn/Z7mFO_[X
OokVjN?bLdN^KWBZ=D>?O6oGKUWN=GCXbMeO1dk0LCbjEKi?nBWNQ:]HOQc7K:S5
DU;YEWdYfDPoGS//nQdXO`oRkH0^2D8^Z0AD3FX4nD4mX27@?]3SX1>P2M2[X=Cf
BKc2P@=mk0_D8PGaA6lBBG3:e_F^RgX/5f:iIV:i4<^5F2k4LR6F2k5LR>E2;1MR
^A3;QEP^a78QUP^aD6eT_n@R_P<@@/UDXBn]P=9dGXZZRjFVP9OZP@_QGXaJ5J=F
YI1;89Nh5U@`=Lg/[<c9c^76;3T3AC7NR^9TX3:R;DBmZU18eF2/dT^gA8R6;=Ik
U[efMVR8lhmI]L;kkY_JdMcB;=ebRd>]GA7hn`H_gkAYgj:ZlY;]cDgLl<N3]KGA
[L[O/KNBf]ZOSGjdEZj8o^SLd4inZnYSXHJjfZY5LadKV[ofKGL=Uhm`O]_b_IMi
b`IlDfFDSSZ^a^lQVf[SELa4NLGBd/0c/C@PT8`eI@458h1>eP5?BdPIda9f9Y]N
R=R;HWE9K25;DmU7dEO/FMV>RQCEeN>bI:AW<<iZGXP68Pglabd>:eLN=O?bC=EI
lNUQbGcE5RgBmaM^n98C`_N6_gJ9;gLLG`aT9KRU_c/XMh@6P/Zm`KjnX?36ZZK?
6Og/lCBe=FflXk@Q]6D`==3C:EcRIi?`]H3`TlJg029?K?Z2C0VIBB?GmDN_jh^C
QOhO;C=:bPYUKVAcM79UHFd:IFiTKf9Z2S8a830PKf9Z2S<d=3<:IFiTKf9Z2S8b
830PKf9Z2RQ]HF=?Db1FIG9cJFm^834`;S4d;SHPG2Q2MFU/I20a>4Lh=e`Y855e
HG9dNR1@A4I3KfidIGQd:@YUKVA_HVX:<S<P<21_HVX::4@j<S0a>C0h<SHb<C<i
=3AJ<30W<30W:@YUKVA_HVX:<B0`86mRJPXl?20_D79_I7ESIG8P<S8P<21B82m3
LVEQM6U_KTAQM6DP<S<P<21B82m=KfA4HGAU838c830PDR0n?PYUKVA_HVX:N79U
IPX`838d2S0`<30`<30`<30P=SDe<cDPIR0:<30`<30a=SPf=R0`<30`<21^80X`
<30`<30b=C@i830`<30`86hP2S0`<30`<3De<c@P<30`<30PKR0:<30`<30`<30b
<R0`<30`<21^80X`<30`<30b=C8i830`<30`86hP2S0`<30`<38f=C<P<30`<30P
KR0:<30`<30`=C@i>20`<30`<21^80X`<30`<30e=SHg830`<30`86hP2S0`<30`
<30`<30P<30`<30PKR0:<30`<30a<S@c>B0`<30`<21^80X`<30`<30b=cHb830`
<30`86hP2S0`<30`<3Dd=cLP<30`<30PKR0:<30`<30`=CHa=b0`<30`<21^80X`
<30`<30e>CLc830`<30`86hP2S0`<30`<3Hb<S<P<30`<30PKR0:<30`<30a<S@a
>20`<30`<21^80X`<30`<34b>C@g830`<30`86hP2S0`<30`<C8f<C8P<30`<30P
KR0:<30`<30a<STb=b0`<30`<21^80X`<30`<34c<CTf830`<30`86hP2S0`<30`
<CHg<STP<30`<30PKR0:<30`<30a=SLe<20`<30`<21^80X`<30`<34f>38d830`
<30`86hP2WAbHFU/IG8:?3`P;e=YNVDP<S@P;e9_Kg@P<C<P<21B82m9KVI_834P
<21B82m9A21K83aR<V8`=V4i=3AQ<VDfICMUICLfHFHf<cLfIC8e>C<dHCh:?68b
HS0fHCTd=64bICIU=fEU=cIQISHc=cIU<SDi<cAQ?R1M83hn2W=dHG9dN79UIPXa
=STd<@XU9DE?APX\>"], "Graphics",
  ImageSize->{368, 281},
  ImageMargins->0,
  ImageRegion->{{0., 1.}, {0., 1.}},ExpressionUUID->
  "7185e281-6e65-481a-b3c3-6ab0a7422a38"],
 "     ",
 Cell[GraphicsData["PDF", "\<\
9E14ARda;S<:9LCUl^G[Yo>Pd<C62S@P<21_HVX:?3`P;daUKVMdJ20e830PDR0_
AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:N06=EcfCg3H<kOT[D<I5I88B
9K;<GI`RECbgOb3Af?5L/XGWR_cm?10PaE]YiIfKfA<Y0WQha9NndfOjCR?mAdbo
Dj1Gn_Sla_Cl@[kl_CcS=IO7WnEOV1MJ[aCR42V<4gj_a?RO8k?CSGoY1DZ;V_G=
e;b]C@eCVXR;UZL;lH@C8mBD1dnG:gflG=PaGKkBCgmnX</[OKXDT8Z2:@MH510R
7TALocEQh1EQ=V4W7^iMZ:RK6b4;S]j7:/K4>@>c<j?7V<g/8NKPUc^PWGU/dV7_
lC_N>h`P?XDQ1g30_0aci=4Yma]^N4?/Yl[F:O2omZJI`PC]gUO?7j2k^j/NNLGZ
:UH4C/i2^?cLh^H9Ui[C>Fh;TT?L7>GBV^<W^0_SkUf<mKPgS5NJoI1R1YdlcT>L
H]kQWPDfEkI>jEj?j5hl;[GUAXoj9TiZL=mQNhndcmUmV4bDOT2faNLQjU5b^S[M
PjkY_0m^A/Ga@dhYS774ToM;VTHN4hjn?;/J`OM^PT>@VS7;kbif64ZdC3eMg9d2
HhSnfEm2Kk8gLgDg5F=WMiaYKQ5gN_N_7ma]GN_=_Zn^9jh^8jFFVjLF_cc/Z3^X
:g^>XaCQn51nOSdggIMMV3kaUYM4jK4Ro?NicLh:g=dWbngEB/L:?o2Ff4WGnKII
APG27e[OJB^EFR;M/oFQ^X5f6XOICg<Y=ck61DM@Mk3DOV_;5A_ST:IiK^oA5UBS
:T3T]QeYfB;A=/IQc55:F]=ADV^c8D^AV0O105Cj_Z5^2]Z>f_Q6CjQ>j_^koPoS
>P2hn`>0iNN_1f`Ne@HDPU:IhJUEIUb[k@6jM4LOJNHQclQBU1T]gmg=fli:<@m;
W:H5ZV`_YUKfCE6gHnHP]if:`cAQA>TdPA5Y5idmfeTkD?G@Q]/DMIjX>KOBGGHW
^L]`WYW6kVo2[[Jn5Z]7k792`?EcQPamfeh2HA4e5c/na8@>Wl/dd/lW]X<hBS`T
AZafYm08E7_CY3_K[21bkIA`P?[NJD:HHo[YkMV>b3EDkECcYVUZ>cY78Mk_l//9
f6>/kNjdjWkZ`WM00I4YFojjM:QeGoBa;a>X34Ae<O:`n8`VaUjO27TJMG8ZCb_U
I@SI0iFn`FC^VU@^LkXXa;WbG0lgZM9/M<ZA0f2/FY8gcS1E/@kR2DMI1/Oi>0I_
1YUO>X[^LB>:bYQH_cQ/<AM^G5R<Xb0IFkm=i755ACAbk1g;0M@88IF2[[ALbJ8D
=i2INcVojIA7j=c/UGMURTEEE45M@NMITS:nY1k;dJL7LcCP@^_GRk2UZnXXkUhm
5XILKKU6DFJ3[_@UmJ2:f]98/UEcETG1Vc:QGe16dfIDGbZT9[[QkB;9nChiV4H?
YT2jO^fM9]]c7dW8=7`N76JJ:><Po^Sl^:e6JkL86^fkLcTU8hWSlXc/@9aX`kBG
hQ_?EB;XdWZV[JZ4RD9G>FFSSSb;gZ[2GR[09[[Q?F4;KZ6^]XoSDk[nf>Sjo3n3
3CX@2VE^I7=dLVEQK@YUKVA_HVX:=B0`86mRJPXa<C8e2VE^I6mRJPXb830PKf9Z
2S`l82mDNG1U82m@HFMU82m@HG9UKW@P<b0`858P;e9ULfmeLV=ULb0f830PDR0_
@fm^M6E^M7<P=20`858P;deUI6UQ@Vmh85/`830P<c8b838f=ed:?Sh:IFiTKf9Z
2SHP<21_HVX:?3`P;e1bKf=CIG@PFb0_D4A682mDIGQd85dP;d=_K6mbDg1QHfDP
?3`P;d=c<B0g830PDR0n?R0_AVm^M20l?20_E5@a83PP<21B2Shn83hn2VE^I6mR
JPXi830PKf9Z2S`l82m<IFiWM6PP<C0P<21B82m>83<P;d5/M6EbKV5dIB0_A6Ef
JF=UDTM282m6JFadIG8P;dI/HGAUA6ESKfAU83hn2W=dLVEQK@Yh0IfFMeACfAJ7
ckdg_M0B8R0Um1Yj2B3B>dPE1569BH1@0XJ49WI41DHD4BUFI5C00DN78V=550^3
PV;G2O8@D<K1DDA5iMf<J`W_[CGcgY[maeWOfNNgemUWkggG^P1@o884`WAH0H0d
XEPDk^_1G18CblCg0QP@0@iH0L3QIVH4AoQ40]Cl_CfIVJQ8a[?fkRj0I;_K;;m@
9W?FognA8SM390H02TGE=San9QOU0YAC/lDI<_l4b_BE:C:6<C8FX@VR[2;Sa:m/
mZOV:k_9V9LVi:4JFLhI_3BNS;]@gYXUhJ><1:5LV2GPIj=l1fFmE4VJ0>Gg:=?C
n9a<030DVEo<ibJQK8TbAA@IkXWb0P08U<@i_78>RoTiJ9h0N:IWi8X4RDURYQ7G
V6WUj<QVn_6cDoUR<B^D`dgQR7Q<coBd38h`5h2_KiI50BEIKIUXTNf]7>g]FMKV
J?VofMlNOU?m?LQjneGa9^c?WT6<WUWOK>b/;kdF0?HTFY/M/kjEE@2dK@I0iN6/
CnlP0?850;CNW?<NQVaNT/CR32L;Rnc/K7<1Wf/^:nPgnin2KlZoQSWgVL_^neHk
YQLoPB=95C=UANFVYjI;A<c<30jGcfCmma3ohl0iJLg9`bbLWl0GlHGXEE7XU0V4
RFRkQCb1F90^I0Z4OmGQOaPf9`LIOYe[56QeG`1mQCU@^4T7b6lm04<S0bA^?gX2
ON]K434:b;jlJ:fA[g>?<W[nioXO2eb:K^5<@B9Ci_H<SfAb9J8/6J?OQ6c10Q:@
1gBP2SB1;S02;60=780cL0?N8024P4P@0iH3;TP2JD04/T4nf00:@C7H0GJ3JW00
e85jd0A>PSI`1U`4El0=L0/<P4M02XK1Bc01gX5Y28;`41FR@JZ@5Z@?VD;F41]J
27U3@E0h50?5@hV@4990nM0VZ1PZPjZQ@e0mm2=d6[X8GH?jX0O@83@6o@5mQ16H
0]=Q3MP0]X3I/3/L24O2bn14N1FL1aO0fn5:^1Hn3[O25n4Kl00/QEo2T`Q0b0P3
dDIH21_aA4:@F2@14B5[TB:T0ZU5VY0>Y1^iSDRALN@31XNQHIPH5/HIhhMIS>5R
EV7FHTX`eIQSV5I<5nHfIQ0cPOV2YF;E/JIH9j`oMPTf4I^=;LAFH8mPFk2G/@?H
HN`k70k7`1WR771n^1QL<Vhe[PBg3mN<^h3[``gQ9_5h_2[N5>n23l5cl69l8Kh:
Oaao7]n?7lJo9i09FPA[PPlQUR0TK2AD41X8i`SmQ172=561Z4md8XH@NLALHRVa
S]Q1_4TL9TjC54V691MB92VI]85DBFXRGBHm9[dQTlTjI4Mb65U0GTn^99lPGbD?
TSm@U2PV54m:74E2fDhiB[U0ND1i@jEB3JQ^e5RZV;ZMFTnmA7e:OBm7Tc>GliOS
bJfCZi5[UN^GNbE?U=NGMiMO;YlWGb5oB_jVo;P2DL50`E>1Xk1FXDKQ]<8mQDU5
VZ:EHXQRVV:9HX?R=LEA9KbBPI:g4TnY@>V`dRFU8AY2djEid[RdCK@jfVGJ<1e7
=jCkdi?YaO@Oj;gd2FDUIE_U:>DLiA[U/lYB1/8`H?PcDQVUS9><^hb?lcCV^LoS
cm/f[fUNok`YUOTZKRYlUB:EIYD1UHnZC5E_eACEWJY]ZToD<6XVJV5ZfF[keBj[
SLnWcgNNcieO=?oTo8OZ/;Z9N[SjJ_G3jSgZTaZJ6[hJ6AYE6YLdaSDIVVjJbI[U
V^LdakAXFP^e15[UF^NeGS2EVNk<E6HU/h/iXJf^kJL]dCjTgJ/m[F>X/eQWXdjc
cQ=MTRiK=d6gG;MCMd9?BbmH;en_DNnQ?U6O[InT_dNoFgo:`=0PfV2;@I_1Z:6:
XKmQWV6ShF<SZY6[dBZSFZ<kaSQS]W6:lCkSFbJ`RIe9TTV=bDeCf=CNE62jckC?
36_VJ2HdZcFkaj:`g5UI[4KFX3W3?<QlXgVKnB/;?H]HRidFgAIO;>d/Dbg[;1mI
:ET5F6fdj[3j`m[4VV]MHgg7QV[SHk?>Y]gV]JfY;Mmf_nem>iYM/=dF^djkcoH>
mR;k9_/a1cf7N8Nm3_OHM7HX^hAmeA7[j>6hc_6<h`LWNbNaddVWgieIcRW>3LjS
2``Gl1OD;AQbdG7Q^1abTBiT;XaON72Qe5GKUN=Jjo[<CMN=igK4KLCMf3gIoKSk
:`m;3i57RlNDYi?W6/l;GXRG[eNAEjngT_MRkf[_Ychj?XTnSChC_WJnZgd_n67m
0_efn]gceo3Wn]OkC`@h1:`9j0ZT14H4EPLn2c894PEe1<?10L6kPQl_dUlTG=@F
0T;l@gJ5?0Te35dEnW<H;R`d[2K/NKQEN7ihM`@]HTE4@lBkB8o8d/Q7RhdFBaIg
A/U7aDGEAde5NdFGAD^GF2aI/nA6S5Z<8:Hm5QlK5G/TMW:Ymm;MBhOSk>8:hnh^
<ebF/ncJL[GUZL_?[Y1O`EUa:QhK7agO4?n94l:YiDb^m5niMnD4ei>kQo^BilH[
ihgaGOQUo944UhBbQ=54UlAMRF=9[TTEBN<2Cd6eh7FbGo:1i:VDT9BS:C>YdJW=
JHBdn;CC@REQR[0[GC<m9kd_`cBS<4>jbVWEkUDCXT3ATD`XLeUV^iR>oTceB8`T
VbF3F@^cJ[;NIdMUWlYAc17Vm>BJi6k;7LWcbO]n=FHeMgEW_WKnQ_c1=Ni[3Zf5
eZiLfkU>Meg1^^7e_^^?KB1]B=W`bdK;SFDKgfj:g]AAX56`_V1X/noVaT:i@U7Q
_Bg>F`i/aF`EK>gMI[>]J]^G8UkAmF;;hX[RCbGLT^_OFGeGnMg<mXC]_JGfYO]g
h7H8MmcMjK[cF9URFEkId:kPGJgUc?:Rl[NkEnbnEV5KLF0?JHmTSk@bZ;:mBZmZ
AmFWjZCZPAZ?V^JmjW^gkIgJam_G_mm]Om<1S@?51chN51blOlSgD6^]@Fg5HMcQ
[<??jj;Z^[mWOemoA>e8lI7?AhE7YLO2SgGE>mCG=jPgU3K2SI;6/N=aafomh?E3
Na>[jE0cXkWh13PQ>O7RaoPOkih<?=UiRWfZjBOmWoJfd5Z:FZ7Fg=J9]Z@fJG]<
NmoYP=>M7LhM;CnKogcdS?JIV[?:Id_?TLhEW9/iWgMnlT;6QO6;RAN7>UMd?[Zd
i=:M[[2^g/^1UjmNlKUbZM^mnoaEUj]W[SUM>gfMOKg]Q_f=eQjkWYIOk7iYjKG_
KKgYL;?mU^>]S[h5ONOjGO/_g_JjONF>oidK0h/6n^h^_W_oG]`mjGgNoM47Z@mN
?laj>?eXoF?/hj8W2TlZWZXo[OgEn=MVZKgdk:3GH<ncR6N?Q[Q3;onEnJm?``G?
ZLl[A[A6jTN]Aln<nHcMN[7daO3;S9OChhFo:OjfmiGAZimnMo^mIf;9a?1[dN^I
?d[NZ;hin]KfKNMTj>CCMfW_YZN:gZ^n?oJ1oJ7kHoC7TNW/CoQ?UIn=?gMl2Ocb
N2I]I^KOmhCcn`YUKVAcM79UHFd:IFiTKf9Z2S4`830PKf9Z2S8f<C8:IFiTKf9Z
2SLP<21_HVX:Fb0_BD=3@V5cIF@P>B0`858PG@YUKVA_HVX:<b0`86mRJPXl?20_
E7U`IB0_D65WIG<P;deUI6UQ@Vmh85/`830P<c8b838f=edP;d=_MFid834P;d]Y
I7<PFb0b830PDR1M83hn2VE^I6mRJPXa<B0`86mRJPXl?20_E7U`IB0_@f5dHFa_
Ib0_D65WIG<P<b0`858P?Sh:IFiTKf9Z2SPP<21_HVX:?3`P;eAiL6DP;dI_KW@P
;e=eHWAiL6DP;eAbMFEDNG1U82m2HG=UAVm^M20_E4iBDE9;:dQUK7IUM6USHB0_
AVm^M4AULf=bJG1dKg8:<C8P<21B82m5KV=_I6U^Ib0_CF5SDVm]HFi5KV=_I6U^
Ib0_AVUbLgA3J65b83@i82m<HG=d@fQQLR0a<3LP;eMYI7AXLb1K83De=PXe=CHP
<20`830P<20`830P<20`830P<20`830P<20`83Hf=b0f=SLP=c8b83Lb<R0f=SLP
=S4a830P<20`830P<20`830P<20`2SHf=b0`830P<20`830P<20`830P<20`830P
<20`830P<20`83De=R0e=CHP=C0`830P=CDf838g>20e=CHP=CDf830P<S8b83D`
<0YM83hn2VE^I6mRJPXa<R0`86mRJPXl?20_E7U`IB0_AVm^M4AULf=bJG1dKg8P
;dI_KWA>HFeU82mDCU9ADT/[B6E/MVEdJF=Q82m6K65WLb0c<R0_AVm^M492KgPP
Fbdi=C4P;C@h<B0a=3@e834a<S9M2Rm9M65/JF=1KVM/IB0`82m1Lf=UKW@P=cL`
82m4IG=SIFid82db<c0P;d=QL4QUJFMXM20g<CLP;e=dIFeF83Th82mHB6EYIfQd
2SDb<b0_DgAUKDPP>3DP;d5fIeMYI7AX83@d<B0_CF5hEfUTM6PP<CD`<20_AVm^
M4IYK6Db834c830PDR0n?PYUKVA_HVX:<C<P<21_HVX:?3`P;daUKVMdJ20a=20`
858P;daUKVMdJ34P>CL`>20_AVU/M6Eb82m6K65dIDAUHfmTIB0n?PYcM79UHFd:
N06mFW]le<Fe?o=kkb>KgLe^mY5miYOMcC/T8B4QPB`Q2N6A61;4;1990X4@@2:?
:5AX@109B4D:F6QEZ_8D/hB86bPfDRcj^Ck@:UH^]KFRmGZKSoINlJZ@gG]n_`dY
Y>Z7?oadOilc<fMVOS=W_W?Vc9WikHYU:e/P1SZ1QYYICNgc@OhU;@HPWG>G=;E7
nCPYfSJgHhD[b[?90?CRnNd;UTAihNL0B_^2aJ^6gXl;0FP[Fe^JiTG;hA[6nJfH
4NG9J8bCFYN/^2o:jg/aW[IhjMbQl[Q7T4mNdWCOD?m`2GWGgDe;FZ;eTbXaCVYO
^Wc542m5UNg;FXKZTgZDkddPV1/7Sh825P4?56SaJ@3P?eGJPL5BZAaoeEfoNGa>
K?4Ed0Tb?jOZIg;lg//7egoML/fWfRilPaV:joFUV4/9Y`2X2IH?Z;H?UlS_HH00
e:F5H39B2E8NDU[J13=dT_g`2=:CB3@/95]P5M9VY5lP<L>Y@lSeTBdmS>0oBEJ1
UDcaZaSW38?5JEJZW6n72=Ok^?=mldNWR0EWkd=RjHT1a@@UNI8l0O?0BIh13eT=
UI1<mQa?FNa/a:93d8kDRDC;8B67NQ`icQM9>WPHP^mh`L6@4ljoIFLh?lh>DJC7
NLHGHS1jbH6L?mKIKgoLnE_k0^N;B4NRAHMC/<H9ib7kH^L>AhS/jG4nJPlAO6Mk
=5YYaeM?>9NTk7;>biK;Ynd:DDMjW8EH?]>_L^HG^9eim/_>;5m88<QWf:LiDk=O
MbKQReS=QHejo3ZWcKk3>AJ;7?IbgeRTDn@`f@^YI6n?Ih[c92Ia^<LWYaC/2Y6O
7:m<c_J4b6YoOVGb[YA:WbMUV]>CD^7cHG[V:o`6oTin0Yo3Yo79_9Mgl`Vl@M0;
FT4SZ0FU80QlR3cKDn;TCY4SD8:`73T^L08K8/mQ9W>:79DcSkhP<08UP608AOj2
bT_04297N[EB2Q<W>3W5QLSAhm6/XghW8jDH^D1;BFT<<0B:21A<PB1i><C1a_R>
4W>9O[b^/:;/nh96^NAjV?Km?c>a1gM=[J/?7[H7PSUB8V8?G:m^_YkhgWS5BRaZ
:De;VeZkjWQ7Nm_llQJa_54/Kd5Z36kYJ3D7>i]M[V=]kE:1:dQk6i_W]TYaDd^`
GF`Y2kJ9IJiS7O9k8h[WBlDMH]TaV5lnXokHO7m;FDn7_j=LK2X;76l^GMI`DenK
Qo]JE_XMOIE:SBfCnVZFga_AEh=Dg2ceeB3eeB3eeNa_U_^B1Unn/:idn@[DCUOi
`ZV^H79ML?;dFOE1Ee>P;4CfHfKIBV3k@L^NQVBf4ja<5SP18^lSGICRl>fACmQc
X0d_ROb3;/99kI>82YLD@cll37^Q6cPhR>UT^0/NPeM96jk]fM0;5hP3<]7f<Q22
JO0JRDCNP_W`==IO0FMP9a`3=Kjc18aH^Xeh8Z^Amf>j6CI4OPe9D00?`VTXa5Jg
`D3TD>@hU]K2kG0HS^3kod54jQPC5gT^LQT4V8i]K/2B]b;C8]fPQg@XQA[<g@0_
4Pmm<M8:IRQ2jGh9Cl0nN0WnC]JCgTQ[Y2=b?_8QZZXIK527ca[BBcjT^iT78kn<
O1H98a;9T8Zm=/8>N0[KklJW7de[>EU4EY0MI2OUYmIC_La6eQ@NA1aBH18nUK0D
7T84n^0/o0ml@cjWc;BFGT6o7<V;o2nXH2Z>DQY92gCP/`VOKCRVDh@SXlQ4DT?F
T9nCWN@?E2Ye>eE?gD_MAge2Em>cjEGd7iSUC0nkUGf<DhF_A4i5cTGN1A?HhDiH
1V]aM6OP?7`9ga8Jfk8A3bTRYN@^O3[9GZZ?k2=mE0gY9nNY`nC?i2?b>KU:/IBJ
<U9Ye0YZ1gF4>T>m@BnTMm:oX?m<Gf76/aBkSofHlo3o6Fh>K`jo4BV:O1Si6Tf/
06jLVE:XQSW@Q:=]Qm7`Dac5DGbjLMK>`/_`Z_alA6``05lS2T3da4YbB1DneN@f
<Yl/98nCToRl:<_b5HDC@BTX7FFRK5@MeD`]XCZYMjU>>X5>YJO@/nQ^O5jQ;m1G
jJ/<bl@aAVHB<aVf<T^H?OS/I`hb?LbKK24kWZeVIk:Mk6If:cfGOH^m`:gU]W4m
g>OL5fPFYo5;nJdh>jnRc[j4^_c?7d>BD?XL^1_VTS;B3;]`=_JA9^Q2kIY77T:l
fR4idT2_YBMAXe0KGXBOX;K^PCF`VIh=nb9oY0o3NjPYj5nPgQmPB/7>k/KIF@nS
D8^67Wm:JTZbcn]94Q?M;SCi]PB[aFb:=a[Rm3Y]S5ZUE0Plac8dAB2mG:aXM0Fm
SD76:eIFITRlf8@ICCMT=>9BMPD[KZhCM4W_=F7ACCGmF7?nR9[nJ4goL4fRMAE3
LDJjZead1El_4edQ<V]j?JHO;Q<3[^20W:jBdho8jAQ<^mghPZ_Lg5[V2Y96EgV`
XZ>eZkba;2>Mm?TA3VE6^V@ho:2B6Pk2a:HeJ61QXUBS?6PEblZ35Q7CF4IkbY_V
1F^VeiNG9KSM0Lc3[=Yjk2<SOF4@iH@]jWWR_2dQ?c@gBZVVfOE1^RT@Y1ZU]WAY
@I=H5SB]o]SlCoIjZWc[3HE1bU?Ae=9E4O@gKT5`9KIAhYZf8SNecXG=DQ/3mD6b
LDP8BLHfU5@B=kXWN1[KG465F2ZfM[De8[Q@FmmSmE]Uha^4V_XNRmlR<aWYONJe
AFhLOEo6Q8`9DUcT=Zn=aWmk89[oM[lDVmNNo@_6Df^70B0B0^9TU3?XVR]g8Z:`
1E;@DP1ML`/@9o`520ic8LXc<DRQc]2N8>^Ig1C/[;/^AV]IE;S6][8NQLDZKd:U
0JcOf:DMRc>5mKFRZn/:k]J=h/3OKliY6/[Q?=X[81E:4cf/:d7BM3gM8FfF7Qae
ZeU/UNJg@iiCi4Ecn@dIb4_@B3873KR1emBkPjh0IZ0gVChe18ZJnV>4K0^4B6AS
2<[/ONRSdW?^`^9dBMDFUV7ob6BTHdJZ6e>IjJh:k;U2dQEGUj][l[`^EhF[5IF9
lLPa5[Ad1K8@`KYja0UVH8on@<9`/RD@68_]I4W]h2]H_B^0;K@=]H2aW9DeR9E6
YN=VBW][jZOG1c_;4X;n/P3>0ZY_Odem/1le=a30F]W3TZ;4JaJJQfC>@IVcDk4l
=mX:nRjMf4BPZd]Z/jiNM0Ok^kXB^ZCe5^E314IVn8Lb@R1ETB0?TLhJO1LSdIdP
ch5KM:=H0@WCdJSBecD:OOHOASQoF6ilL`a:VblSG?0S8Eah:`R?_BF4RhHU_@WQ
HYBiB49hg;l?hO4g8Ecb``SkQnE68BNP]7hIhM8O2N69]h9`fBdQG3h/jDd8Ej3<
iA;2Toim25ONQ?3T7dIhb[3L:>ADU7J:S?2d7`WQZU]1^?ZF4;i]F=:K4:i1VFnC
49knkd>hmRJ4jghHhAW3LZ>@]j>d<fB4Ioi82=ma:`SGga;2PF59Kd9h5/XLT12n
LaQQOd8@K[C3WB?<;_cXQWWf3I2SYlCZXIAI3VNAo>a<L23]a_?G;:AW<=g=O0CM
L[`LJ[5>1ajlRc2^Y0[1Q_4hY0gTG>@RiWMRLmO_PMAh>Y7hK3`7A@oWb7c?SlHc
6h_eNOCcooFWn=N/4CU:?>>X<Bl6=12;]e80>SbCAGoi<1/naK?CemA3e6Md9]e8
Wf0jVLoHaE`n]ii?iEOc_D8B7PA:0IScN2JUDHZ9dO/V8B/439:Pa@^hldPBSfWj
4ZHaiS6V<EILPY?h5/3<]9?H4X_aZ>aLWE_W@bYU]XF^oIDmoNg445=e5Nl_48fc
N4ga;_/XSUHl9Y0@bOF[6HIG<o`^5YBC5=Z>/nJck`hF@TW9UjmWSh[;6do6i>Y4
gMWOkO5^jjNojXX;k?ofK_X[^Bdob^ePO`F9/=mOWLmD<7N`Rnag>eHk=Y1=U90Z
c;8//]a_^Mof_8F5A1;;f3@F=fnch1dEjhb=CHaCi/Fa;^M:Mj;JoE>n87iYX/HG
^liIT9PdBICTN6OPb`7]UH7;D58lF5`bX=<GI^U=Q@ASOF6Q3P=Xb1heLIGOaUSD
7YeGYMLTPl;09a<;4j=E9Q?1R07NeVVeA;XLF0L=nOXBTSlV?fndEdcT>Ek4]3]7
KcC`G2cQ<<=]M4oIn5;o^]6e^mKdCO8b;m2U:dWbEan]ZWQnLg?1?2^]^IKBAoC]
BjOVeBeJ/f?[e8fW>/j7_g[ZfMFCFZKUImoAMQQaXL61VSd>ii<2BC/^nV/ZBCeY
9OA3m6kV<NDQIDPADW;9BP8laa5:D2P`D0;?TZf4IU`6YM:Sac`3bg[dF46UHVV5
T^5HXZ883IB35d8Th5OP/HUC:6TF^H=nODb<bFAU7bN?:bgZV7g^[GOQ[I2UnT]c
eN2PYKZlYNbCRS8cU9R:BhZ[1Q5>GF6916@DbJa=VFU[]5?A^f?j4h;<fL2VC?=@
1XdIm=U0fU3MCM[RHQhYNaAYJ806XR9a^DBTgKA8j6eo7]Sh8FFl^7?`e1>_DHm@
/jS=PoOBLknMB4;QBUVkMb<^3:JDN0nB3>_m1K=RI^WJZ;JH=]eZjUhg?cVVDTOI
1FL/hha337f2`dBY73j1bDiH69/]FU<EATmb_2DU=DCV77Mgc<LQEWlYSJMJneDE
:P^D39H<X9H<bTXRjhKNK6D5RhOclVHVSK1F8@de@U:7MN]`12A7DPJOEgC[KTSB
KYMdATEmR8o6:H@j^kKRkYFUjl>o8TMOZ<knfK@ehIFoXnhUe1;oKBUEmaC<3F`<
Oc2hPjhAaoc/TAaK^71`E]_4>Dn>M@iNIN?fg7W_UT2F;bfolM2fiLnRE/b:G6C_
HCl6>f[:<GmA0[^Kk69Y9g4bjlTVMW<LFbO@3mYe>R<geTj[aaXE3/[Q/=3IE94f
FfMe:K8]5ZM[Wk/]2T3E`=3`LNBhK0MT2;@3l_37P/gTRO=Z?0UNEK`R1f8<fQbR
elEZNA]b;=0iQ50<[CB[Lb1FSh5PiG88@c2@UPcA5V^;L@79XIBa[X4d2<@TIQ8a
4GAJOBh2>2HGUhkKiO?Z];RLA<I1A^_>^5o^NCmliAnOGeXncW76nVQgn;d8??Oa
/bO9Y6Cfho35Dm_fQml<_a`>Qgmk:;3mdenMg_/jNIJDWol[[Ql:WT4mVH]j4X=g
E@_lcTfjGGXZAe0iHRU`V0@Q>liZSO5X;1K[1GO7IUT9ZPIU32@569@7kRGa>XoA
bo4/co0dCo4/Ym@:>=Yh31AjE@kQ3GSkPD=<Bd^Ea^FAAR;I1Rf5fR2[P<k0DcSe
ie/V[9QBI8emoaoQ9ejQjTSFPIgeNl<?3WHO=_ZF1[KDCB8jTWWe<CK^_C?Q]chk
7NjAam2=]W40ab3]3]Gn9=k1<2[JPK^A@W0XEH:JDZ/Yh1IBA@Z[QQHlH8WAQ8SZ
^7_Wm@79B_gUILWZhJa:5[1HeVddbVRVM4=4^YV/Jc_X]6__d_MO?D<ifM>mhM;3
HDdgMXdoPWLl`1a6AP65O[<TQF982VhA/J[TWYFZ4;T3Nkhd1:GL<e[MOne@k:J_
GW^=NV/`jicLDOOP?6VnY3jnaSjDH80VOmi2mD;m:_EZ?E=YZ3Nd6UHK65i`j;AJ
9M74BPPX1H[CZaV5`I3=F>=S5CQhHoag37i@QnHn>WH]XX0@43Ch3G7^75bM7<jB
2?;BMNOTigEC>lmnLN63L<hi^_>nd^GQ5FC[P`OHdgmjiMW8h0jVKj`cC2mkA;;=
]I5;lTeJ;?X6aO0WOd7Z::;DZQ;D=Um^YGJQXTg;5`Yj]H9>b>6C57J]fUjDAVFV
5;e@A1GUY7[dFYhEK;i4Tbe4^_bRbNkTOOI<5FG?DaGcaLDf0inBNS39>ShQaCHU
eUMP6COn=f@gGR3fTEd@QAO]U:B[U`O?3ZoGTP6LFFV`3CSKV@>I0i9YeYT:IDe>
cQmSC0ARlI3lF3NH7@U^R7LIg<BM26<X=eS]9SLa^S50IIHF[;a<en5VAaZBhZGe
>HiXR;bm6FoJnlJCg1`dKcX3E/8^=;RROEjO57WcA^N?RB>JIMEc0[_L[CU;V[?[
B>mhXoZ1e@lG^ID7fOmkjWC7BY=7kM2UYW/KD^<EHmjhOnOYTk^kgYbE?WWoMZ>=
dlCH/QJ@aD:j>F=fgKCD^]o_[JalK72g;I6V=jZiD]5OfOKl@c^OSR>G9OgYR7c0
N=Pcj3TiX=fO^IloH7_?ARL:/@j:1C3IFEjWM=QE:X=?/;Z/VMY<TP8j=86Kg:LK
[^l1Ubl?FH01b@CZd3n@dC?[hcUU?6O`4[dB0b=_lY8hQL<KGOTBC76i>PT:_Li0
b@PHaJBXPl0I3JKhg8k^XZLKGoWVZh^[In@DkZOVKmonl4oj_9?>/6L6ok]ZNWPP
o6Dh72`BZcJ_nOC5@anLN6_gGLOTmHngaoAiYQZ/T007o5T7;>@ald7Q/9VN8^Sf
6VSJ`=V]O8cMX4[P4a9<FYnNd3i:IkD[OBJ;3CnYlLOMbmH<J@b>[;QZX;1@F_lS
;OaX/0PN]E7Y1DfL5TLYfGH;LVSKgK9]ElG7N=6fHj0`Lek9][^o`kK;nP;aDL_>
hm1U[LREe87:dd8^Ceghb=B]GKKffBVS7WZdo@5;]n>;DfmoBoC_f9SZh7]c7cRh
i<UmUcKOnnk;9?LC_?XNRoe39G[VE[be]^4G3PmAneO]5WiQ?N2TF@dEbaZ<6Wf/
dN1Gn`e2RYE<EIfPci7OdnLBoRRl[kSPo:?hZNUCDGE>Mdi?cAIHMe;/WWQkDR77
lo5^^heGf^=E7WjgkH3]1M@EaQ<Ojk6a5ZFJej4?JONaEUmB9^ncF;bnMmckXdYB
=AQETGL6IJm7MWjb6XKaA?>RUGa<FFdZ@6AH6Sl949KQW;RcjKEaFX>FhMBNa8@T
;kS0kRD>^l;4Nd5Ue7Q9S4Jd^S6;aD0`8okXPGY1FY;A=BV_bmBde7GTWPJh1gdW
M2e`mKTMZ7[B5ZXQj6i`lZH:^LB;MRfAh`WENj4PGjnmmSWkb>j7Ih`b7>=_bjiM
=J7fUO1Wa?aGhU@UCcUjod6FR<bTAKM?GccUednmg90oZFQkIXe=BdCl;T:Ad[1g
ILGjhee4n_2>nh4=5ib9OA^oY5CidgPkYkCC9=I@61o3jIDFM24e<KXDTikGafZL
6TYccF0aFjji5j`MfQXJ2/m:MUP[NiBBJDKWZfCP7G@fm6?bLg?RCDK9<n2<^DHA
3`eRGVkNlf99[bk9I;>XJUdm_CdkMk:UXfMCe=<D^OfiKMOVdKoLMQ3UXV5L^8Sn
57G52AWh9Nd5OeFnHK8`FE4_11@?Z@lU7;@Ol^e?jd]@n@Dj?S55LeJIR:JGhE;/
5ZGN[Xc=i3<cFA^M6InITL9JAjTe_YSaGYo=TSEZTg]IjK3U;IB<a>3U:d>k:_Y:
J2gTJHo>NkZHK7FXM4TN[EMdN;f@K<E0Ym:h8EJSS_7H4kg4Ui22jdV]Ml^c>n@Q
hCB_Th`9h:cViJ;S`;TC_KiLW69YNVF[VZC3I@Cb`D=NGNQZ4>[n^g;cmQNgQelm
nWO=2c6nL@nljOOBnHn]NBilUO0WBMWC?gfa`[?SoS>gYHOOHT[7Ra<gGL]i[N?R
gVLZOLF?c_aCKLgo4C^98IWQOOdmLoHlOkYkkPHZ@ikW3@SZ0=[DN:ScYn>Z4Dbl
BO0a_[REo4Y1R8^QhXahE;Ec_56]S4UAF/g4V0;a5Y<Ioi5`g=dLQFcH]lHSV6aE
2hVd@6BSRKiBM0<AMI87SI>^4cOdnW?_F?mOMAUmS^a=kBMjdDQNV^h^O2[`n>1d
jZV><OEk;Pbn8^TQ5KTH[R45j3?@J?GaK5^7aeM9?FORob^8M;hm7cgW:/kS5eD=
E]1UWLBjdSUgE3I1aB;SBIi>AQXg;1lYj>d=ogYEMZng91QSMc83iklIcHRcVA=G
aj`Lfda9;f;SWHR9i:NXd2;?2e1T[40/52hl4gL7^h1MaMg7Kf;kj5OYRkBBICWl
0h62YSI@?dMUYJU2?98a;7j/hYKX4Df1almF;:L@F<UmA_n7iY@lYnB/<@Y:V@8Z
?8Ce^9_kB7adeiN0;;IDJco1<ePaNW8UdVi?T3IEIJH9Jk@_<M:AZh5MXngG2/F2
O;i2<k4<=bNBZl2Uc>_4cZ?TSDo2llVaCl8m^hnbYjlM8NO2B`NK:E]Gn6hL7bD=
4[mR]n2ge^ojBGom<N392fdaN<679k0DE<Pb:8L:o8Xk6Onh<1FZl2^WQ9@NBOYa
dXg6S>[JjKECdbYK5WNd[5Ph]dV^8AMS<0>Y4JTMZA<9WBah4RV8e8md7^T_B5m8
cB9YTEa8Xi3lB3E8SDS]TJ4Oh6lhCO0>ifHnI`@oH@AO>X:O>88_6l6GSn0[A_0X
gdgbB:>oDKkV4OcL4K`l5cN<Ioj8lPDSn=HAO=/8OY74oco4dOFZ2VE^I7=dLVEQ
K@YUKVA_HVX:<C@P<21_HVX:=S8g>@YUKVA_HVX:<CDP<21_HVX::6eQHdmC85IU
LW=YKfhP<C0^<C@^=R1L:49eJFaT834hAcPgG2TPDGEQLWAj8514AT=_KWAUN7@Y
2VE^I6mRJPXa=R0`86mRJPXXA3Xb<34i<3Pb=S8a=3Dd=5X`<2L`<2LY2VE^I6mR
JPXa830PKf9Z2S`l82m@LVmTMF=ULR0a=B0`858P;d=bIF5dJFm^A65dIB0a=R0`
858P;de_I4AQM6DP<CHP<21B83hn2VE^I6mRJPYhLVEV2S0P<CL:<30`<30`<30`
<20f=CDc=B1V80X`<30`<34a=38f830`<30`86hP2S0`<30`<34b=34P<30`<30P
KR0:<30`<30`=38a<R0`<30`<21^80X`<30`<30`<38b830`<30`86hP2S0`<30`
<34b<S4P<30`<30PKR0:<30`<30`<C<d=B0`<30`<21^80X`<30`<30d<CLg830`
<30`86hP2S0`<30`<3@c=3DP<30`<30PKR0:<30`<30`<C@d<R0`<30`<21^80X`
<30`<30d<CDf830`<30`86hP2S0`<30`<3@b>CDP<30`<30PKR0:<30`<30`=3Hg
<20`<30`<21^80X`<30`<30d>C8`830`<30`86hP2S0`<30`<C4b>3TP<30`<30P
KR0:<30`<30a<C<a<20`<30`<21^80X`<30`<34a<cPd830`<30`86hP2WAbHFU/
IG8:?3`P;e=YNVDP<CLP;e9_Kg@P<C4P<21B82m9KVI_834P<21B82m9A21K83``
=F4`<SLf<C@iI68fI3TaI3IT<38hHc0a<F8iI3=UISh:?30eHC0b=cHa=3UTHSIT
>C5T=V@`<SQS<34aHSUT<fEV?R1M83hn2W=dHG9dN79UIPXa<CD`<@XU9DE?APX\>"], "Graphics",
  ImageSize->{322, 267},
  ImageMargins->0,
  ImageRegion->{{0., 1.}, {0., 1.}},ExpressionUUID->
  "44d9cf53-6dcf-483e-8726-83fb2931bf18"]
}], "Graphics",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 CellChangeTimes->{{3.775045702902423*^9, 3.775045712835864*^9}, {
  3.7750511197082872`*^9, 3.7750511572377872`*^9}, {3.775842851306038*^9, 
  3.77584286824922*^9}, {3.775843091684517*^9, 3.7758431171296263`*^9}, {
  3.7758446238054953`*^9, 3.775844628240522*^9}, {3.775844827008206*^9, 
  3.7758448333890047`*^9}, {3.775901145988531*^9, 3.77590115497219*^9}},
 ImageSize->{280, 329},
 ImageMargins->0,
 ImageRegion->{{0., 1.}, {0., 
  1.}},ExpressionUUID->"4e618e09-678e-42e5-a911-b9e852e775ea"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Given", " ", "AB"}], ",", " ", "AC", ",", " ", 
    RowBox[{"BC", " ", "with", " ", "angle", " ", "bisecto", " ", "AD"}], ",",
     " ", 
    RowBox[{"returns", " ", "BD"}], ",", " ", "DC"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"FindAngleBisectorDivision", "[", 
      RowBox[{"AB_", ",", "AC_", ",", "BC_"}], "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"BD", ",", "DC"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"BD", "=", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"AB", "/", 
            RowBox[{"(", 
             RowBox[{"AB", "+", "AC"}], ")"}]}], ")"}], "BC"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"DC", "=", 
         RowBox[{"BC", "-", "BD"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"Return", "[", 
         RowBox[{"{", 
          RowBox[{"BD", ",", "DC"}], "}"}], "]"}], ";"}]}], 
      "\[IndentingNewLine]", "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"K1", ",", "K2", ",", "K3", ",", "K4", ",", "K5", ",", "K6"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"s1", ",", "s2", ",", "s3", ",", "s4", ",", "s5", ",", "s6"}], 
     "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"a", ",", "b", ",", "c"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Clear", "[", 
     RowBox[{"AD", ",", "BE", ",", "CF"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a1", ",", "a2"}], "}"}], "=", 
     RowBox[{"FindAngleBisectorDivision", "[", 
      RowBox[{"c", ",", "b", ",", "a"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"b1", ",", "b2"}], "}"}], "=", 
     RowBox[{"FindAngleBisectorDivision", "[", 
      RowBox[{"a", ",", "c", ",", "b"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"c1", ",", "c2"}], "}"}], "=", 
     RowBox[{"FindAngleBisectorDivision", "[", 
      RowBox[{"b", ",", "a", ",", "c"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}], "=", 
     RowBox[{
      RowBox[{"FindAngleBisectorDivision", "[", 
       RowBox[{"a", ",", "b1", ",", "BE"}], "]"}], "//", "Simplify"}]}], ";", 
    
    RowBox[{
     RowBox[{"{", 
      RowBox[{"g", ",", "h"}], "}"}], "=", 
     RowBox[{
      RowBox[{"FindAngleBisectorDivision", "[", 
       RowBox[{"a", ",", "c2", ",", "CF"}], "]"}], "//", "Simplify"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"j", ",", "k"}], "}"}], "=", 
     RowBox[{
      RowBox[{"FindAngleBisectorDivision", "[", 
       RowBox[{"a2", ",", "b", ",", "AD"}], "]"}], "//", "Simplify"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eq2", "=", 
     RowBox[{
      RowBox[{"K2", "/", "K1"}], "\[Equal]", 
      RowBox[{"a2", "/", "a1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eq3", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"K1", "+", "K2"}], ")"}], "/", "K3"}], "\[Equal]", 
      RowBox[{"e", "/", "f"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eq4", "=", 
     RowBox[{
      RowBox[{"K4", "/", "K3"}], "\[Equal]", 
      RowBox[{"b2", "/", "b1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eq5", "=", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"K3", "+", "K4"}], ")"}], "/", "K5"}], "\[Equal]", 
      RowBox[{"g", "/", "h"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"eq6", "=", 
     RowBox[{
      RowBox[{"K6", "/", "K5"}], "\[Equal]", 
      RowBox[{"c2", "/", "c1"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fixK", "=", 
     RowBox[{
      RowBox[{"Solve", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"eq2", ",", "eq3", ",", "eq4", ",", "eq5", ",", "eq6"}], 
         "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"K2", ",", "K3", ",", "K4", ",", "K5", ",", "K6"}], "}"}]}], 
       "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"fixs", "=", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"s1", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"e", "+", "a1", "+", "j"}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"s2", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"g", "+", "a2", "+", "j"}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"s3", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"g", "+", "b1", "+", "f"}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"s4", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"k", "+", "b2", "+", "f"}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"s5", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c1", "+", "h", "+", "k"}], ")"}]}]}], ",", 
       "\[IndentingNewLine]", 
       RowBox[{"s6", "->", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "/", "2"}], ")"}], 
         RowBox[{"(", 
          RowBox[{"c2", "+", "h", "+", "e"}], ")"}]}]}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r1", "=", 
     RowBox[{"K1", "/", "s1"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r2", "=", 
     RowBox[{"K2", "/", "s2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r3", "=", 
     RowBox[{"K3", "/", "s3"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r4", "=", 
     RowBox[{"K4", "/", "s4"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r5", "=", 
     RowBox[{"K5", "/", "s5"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r6", "=", 
     RowBox[{"K6", "/", "s6"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"S", "=", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "c"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "r1"}], "+", 
        RowBox[{"1", "/", "r2"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"c", "-", "a"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "r3"}], "+", 
        RowBox[{"1", "/", "r4"}]}], ")"}]}], "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "-", "b"}], ")"}], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"1", "/", "r5"}], "+", 
        RowBox[{"1", "/", "r6"}]}], ")"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.775676982984623*^9, 3.775676983584867*^9}, {
   3.7756770192568207`*^9, 3.775677051168605*^9}, {3.775677134841332*^9, 
   3.775677232481958*^9}, {3.7756772879292307`*^9, 3.775677353401104*^9}, {
   3.7756774684503107`*^9, 3.775677469058258*^9}, {3.775679152828561*^9, 
   3.775679169429099*^9}, {3.7756802426419992`*^9, 3.775680274094976*^9}, {
   3.775680313463566*^9, 3.775680321782488*^9}, {3.775680447431952*^9, 
   3.775680516550831*^9}, {3.775681620314855*^9, 3.7756816916260357`*^9}, {
   3.775681829410972*^9, 3.7756818509458714`*^9}, {3.775681883413978*^9, 
   3.7756819107138367`*^9}, {3.775681942611854*^9, 3.775681946802541*^9}, {
   3.775681978235602*^9, 3.775681995666765*^9}, {3.7758428985738907`*^9, 
   3.77584294713898*^9}, {3.775843233771035*^9, 3.775843247155312*^9}, 
   3.775843288107403*^9, 3.775843371036619*^9, {3.775843764988977*^9, 
   3.7758437660784407`*^9}, {3.775843887940188*^9, 3.7758439334358273`*^9}, {
   3.775844946206081*^9, 3.7758450080456877`*^9}, {3.7758450920875177`*^9, 
   3.775845138174267*^9}, {3.7758455152475853`*^9, 3.7758455365987167`*^9}, {
   3.775845669479705*^9, 3.775845709318431*^9}, 3.775845782096161*^9, {
   3.775846021067437*^9, 3.775846061111393*^9}, {3.775846106104864*^9, 
   3.7758461066473*^9}, {3.7758518244158697`*^9, 3.775851825024139*^9}, {
   3.775851865120068*^9, 3.775851908896134*^9}, 3.775853230035695*^9, {
   3.775901164702345*^9, 3.775901215045183*^9}, {3.775901312774395*^9, 
   3.7759013159281807`*^9}, {3.7759013778171787`*^9, 3.775901381132923*^9}},
 CellLabel->
  "In[126]:=",ExpressionUUID->"bd073d78-17cc-4545-acfb-64d18df0ca3f"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "-", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["s1", "K1"], "+", 
     FractionBox["s2", "K2"]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "a"}], "+", "c"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["s3", "K3"], "+", 
     FractionBox["s4", "K4"]}], ")"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"a", "-", "b"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox["s5", "K5"], "+", 
     FractionBox["s6", "K6"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.77590138732537*^9},
 CellLabel->
  "Out[149]=",ExpressionUUID->"2d557b46-b3fe-41ff-b061-390a1233d4be"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"fixK", "//", "Factor"}]], "Input",
 CellChangeTimes->{{3.775679252524563*^9, 3.775679254187633*^9}, {
  3.7758528551627502`*^9, 3.775852857377214*^9}},
 CellLabel->
  "In[150]:=",ExpressionUUID->"45b5f6ca-017e-4176-abf1-ac6f0e70361d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"K2", "\[Rule]", 
    FractionBox[
     RowBox[{"b", " ", "K1"}], "c"]}], ",", 
   RowBox[{"K3", "\[Rule]", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", "K1"}], 
     RowBox[{"c", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}]]}], ",", 
   RowBox[{"K4", "\[Rule]", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", "K1"}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "c"}], ")"}]}]]}], ",", 
   RowBox[{"K5", "\[Rule]", 
    FractionBox[
     RowBox[{"b", " ", 
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", "K1"}], 
     RowBox[{"a", " ", 
      RowBox[{"(", 
       RowBox[{"a", "+", "b"}], ")"}]}]]}], ",", 
   RowBox[{"K6", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", "c"}], ")"}], " ", "K1"}], 
     RowBox[{"a", "+", "b"}]]}]}], "}"}]], "Output",
 CellChangeTimes->{3.7756792550632277`*^9, 3.775680336065507*^9, 
  3.77568054259266*^9, 3.775681005608961*^9, 3.775843299564063*^9, 
  3.7758434792842197`*^9, 3.775845166514432*^9, 3.775845798497518*^9, 
  3.775846082176362*^9, 3.775851955176079*^9, 3.775852858247644*^9, 
  3.775853242708112*^9, 3.775901271948763*^9, 3.775901340155867*^9, 
  3.775901405979303*^9},
 CellLabel->
  "Out[150]=",ExpressionUUID->"3efc6c49-4789-4257-993e-3e757533831e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"e", ",", "f", ",", "g", ",", "h", ",", "k", ",", "j"}], 
  "}"}]], "Input",
 CellChangeTimes->{{3.7759017357900753`*^9, 3.775901740405184*^9}},
 CellLabel->
  "In[155]:=",ExpressionUUID->"36d0fca0-a6ca-4a70-b9d2-40fc5478aab0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"BE", " ", 
     RowBox[{"(", 
      RowBox[{"a", "+", "c"}], ")"}]}], 
    RowBox[{"a", "+", "b", "+", "c"}]], ",", 
   FractionBox[
    RowBox[{"b", " ", "BE"}], 
    RowBox[{"a", "+", "b", "+", "c"}]], ",", 
   FractionBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a", "+", "b"}], ")"}], " ", "CF"}], 
    RowBox[{"a", "+", "b", "+", "c"}]], ",", 
   FractionBox[
    RowBox[{"c", " ", "CF"}], 
    RowBox[{"a", "+", "b", "+", "c"}]], ",", 
   FractionBox[
    RowBox[{"AD", " ", 
     RowBox[{"(", 
      RowBox[{"b", "+", "c"}], ")"}]}], 
    RowBox[{"a", "+", "b", "+", "c"}]], ",", 
   FractionBox[
    RowBox[{"a", " ", "AD"}], 
    RowBox[{"a", "+", "b", "+", "c"}]]}], "}"}]], "Output",
 CellChangeTimes->{3.775901741583744*^9},
 CellLabel->
  "Out[155]=",ExpressionUUID->"90a41c86-4911-4009-af48-b28ed5ec1622"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"S2", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"S", "/.", "fixK"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.775680089654439*^9, 3.775680121501436*^9}, {
   3.775680619503828*^9, 3.775680661328032*^9}, 3.7756807887441483`*^9, {
   3.775682145315353*^9, 3.775682147825729*^9}, {3.775843305347498*^9, 
   3.7758433360440187`*^9}},
 CellLabel->
  "In[152]:=",ExpressionUUID->"bcf1dbcd-d87b-4171-a538-9f47a4a1568f"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox["a", "2"]}], " ", "c", " ", "s3"}], "+", 
   RowBox[{
    SuperscriptBox["c", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "s2"}], "+", "s3"}], ")"}]}], "+", 
   RowBox[{"a", " ", 
    SuperscriptBox["c", "2"], " ", "s4"}], "+", 
   RowBox[{
    SuperscriptBox["a", "3"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "s4"}], "+", "s5"}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"c", " ", "s2"}], "-", 
      RowBox[{"a", " ", "s5"}]}], ")"}]}], "+", 
   RowBox[{
    SuperscriptBox["b", "3"], " ", 
    RowBox[{"(", 
     RowBox[{"s1", "-", "s6"}], ")"}]}], "+", 
   RowBox[{"b", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], " ", "s1"}], "+", 
      RowBox[{
       SuperscriptBox["a", "2"], " ", "s6"}]}], ")"}]}]}], 
  RowBox[{"b", " ", 
   RowBox[{"(", 
    RowBox[{"b", "+", "c"}], ")"}], " ", "K1"}]]], "Output",
 CellChangeTimes->{{3.775680097163303*^9, 3.775680123311322*^9}, {
   3.775680640232983*^9, 3.775680662188064*^9}, 3.775680802480034*^9, 
   3.775682025379616*^9, {3.7756821486472607`*^9, 3.775682156213097*^9}, {
   3.775843313847343*^9, 3.775843338760651*^9}, 3.775843483483767*^9, 
   3.775845176938449*^9, 3.775845802090036*^9, 3.7758460856623*^9, 
   3.775846116897987*^9, 3.775846403084466*^9, 3.775851970457921*^9, 
   3.775852415632128*^9, 3.775852878010702*^9, 3.775853246364024*^9, 
   3.77590141000182*^9, 3.775901440466271*^9},
 CellLabel->
  "Out[152]=",ExpressionUUID->"9fd0e2fc-fb2f-4dee-a25e-2074825da7af"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num", "=", 
  RowBox[{"Collect", "[", 
   RowBox[{
    RowBox[{"Numerator", "[", "S2", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"s1", ",", "s2", ",", "s3", ",", "s4", ",", "s5", ",", "s6"}], 
     "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.77584593803938*^9, 3.775845945238502*^9}, {
  3.775901459813649*^9, 3.7759014817166843`*^9}},
 CellLabel->
  "In[153]:=",ExpressionUUID->"28d58d58-2a93-4505-9666-ba6d560dfc11"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["b", "3"], "-", 
     RowBox[{"b", " ", 
      SuperscriptBox["c", "2"]}]}], ")"}], " ", "s1"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["b", "2"], " ", "c"}], "-", 
     SuperscriptBox["c", "3"]}], ")"}], " ", "s2"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a", "2"]}], " ", "c"}], "+", 
     SuperscriptBox["c", "3"]}], ")"}], " ", "s3"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SuperscriptBox["a", "3"]}], "+", 
     RowBox[{"a", " ", 
      SuperscriptBox["c", "2"]}]}], ")"}], " ", "s4"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["a", "3"], "-", 
     RowBox[{"a", " ", 
      SuperscriptBox["b", "2"]}]}], ")"}], " ", "s5"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      SuperscriptBox["a", "2"], " ", "b"}], "-", 
     SuperscriptBox["b", "3"]}], ")"}], " ", "s6"}]}]], "Output",
 CellChangeTimes->{
  3.7758459485004787`*^9, 3.775846121045066*^9, 3.775846406079276*^9, 
   3.775851981792831*^9, 3.775852420194077*^9, {3.775852882926805*^9, 
   3.775852910592413*^9}, 3.775853250691526*^9, 3.775901482713513*^9},
 CellLabel->
  "Out[153]=",ExpressionUUID->"b79a51b4-c55a-49a1-b93a-aef9cdb25802"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"num2", "=", 
  RowBox[{
   RowBox[{"num", "/.", "fixs"}], "//", "Simplify"}]}]], "Input",
 CellChangeTimes->{{3.7756801475184593`*^9, 3.77568016620562*^9}, {
  3.7756806768479557`*^9, 3.7756807188785353`*^9}, {3.775680795048175*^9, 
  3.7756807999749527`*^9}, {3.775682110947597*^9, 3.775682113497677*^9}, {
  3.775843319419484*^9, 3.775843328714746*^9}, {3.775845186998769*^9, 
  3.775845187901677*^9}, {3.775845958071877*^9, 3.7758459677944927`*^9}, {
  3.775851989712679*^9, 3.7758519910801573`*^9}},
 CellLabel->
  "In[154]:=",ExpressionUUID->"f6232fd7-9882-4f8b-b5ea-3af51277d8c7"],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{{3.775680160909388*^9, 3.775680167185718*^9}, {
   3.77568069209897*^9, 3.775680720092354*^9}, 3.7756808060977163`*^9, 
   3.7756820366721888`*^9, 3.775682114390254*^9, 3.77568216021535*^9, 
   3.775843344978709*^9, 3.7758434870947733`*^9, 3.775845206844926*^9, 
   3.775845840570496*^9, {3.775845965689909*^9, 3.775845969070743*^9}, 
   3.77584612754091*^9, 3.775846409142956*^9, 3.775851994295397*^9, 
   3.775852431467977*^9, 3.775853253717102*^9, 3.77590154249855*^9},
 CellLabel->
  "Out[154]=",ExpressionUUID->"c0a12348-48d3-439f-8da2-4b0cc06c31e8"]
}, Open  ]]
},
WindowSize->{838, 1129},
WindowMargins->{{Automatic, 780}, {Automatic, 74}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1300, 22, 242, "Text",ExpressionUUID->"3b253b36-7527-4638-b54d-48bdbb2a433f"],
Cell[1861, 44, 258, 4, 35, "Text",ExpressionUUID->"bb4009fc-896b-4c81-974d-da28017f000b"],
Cell[CellGroupData[{
Cell[2144, 52, 382, 8, 30, "Input",ExpressionUUID->"0c1d6593-ff81-4368-bb5d-ae93290bc519"],
Cell[2529, 62, 41032, 641, 292, "Graphics",ExpressionUUID->"4e618e09-678e-42e5-a911-b9e852e775ea"]
}, Open  ]],
Cell[CellGroupData[{
Cell[43598, 708, 8840, 242, 808, "Input",ExpressionUUID->"bd073d78-17cc-4545-acfb-64d18df0ca3f"],
Cell[52441, 952, 724, 26, 51, "Output",ExpressionUUID->"2d557b46-b3fe-41ff-b061-390a1233d4be"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53202, 983, 258, 5, 30, "Input",ExpressionUUID->"45b5f6ca-017e-4176-abf1-ac6f0e70361d"],
Cell[53463, 990, 1478, 43, 53, "Output",ExpressionUUID->"3efc6c49-4789-4257-993e-3e757533831e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[54978, 1038, 266, 6, 30, "Input",ExpressionUUID->"36d0fca0-a6ca-4a70-b9d2-40fc5478aab0"],
Cell[55247, 1046, 895, 29, 52, "Output",ExpressionUUID->"90a41c86-4911-4009-af48-b28ed5ec1622"]
}, Open  ]],
Cell[CellGroupData[{
Cell[56179, 1080, 438, 9, 30, "Input",ExpressionUUID->"bcf1dbcd-d87b-4171-a538-9f47a4a1568f"],
Cell[56620, 1091, 1692, 48, 56, "Output",ExpressionUUID->"9fd0e2fc-fb2f-4dee-a25e-2074825da7af"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58349, 1144, 450, 11, 30, "Input",ExpressionUUID->"28d58d58-2a93-4505-9666-ba6d560dfc11"],
Cell[58802, 1157, 1375, 45, 37, "Output",ExpressionUUID->"b79a51b4-c55a-49a1-b93a-aef9cdb25802"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60214, 1207, 610, 11, 30, "Input",ExpressionUUID->"f6232fd7-9882-4f8b-b5ea-3af51277d8c7"],
Cell[60827, 1220, 603, 9, 34, "Output",ExpressionUUID->"c0a12348-48d3-439f-8da2-4b0cc06c31e8"]
}, Open  ]]
}
]
*)

